@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin.inputs

import com.pulumi.aws.guardduty.inputs.OrganizationConfigurationFeatureAdditionalConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property autoEnable The status of the additional configuration that will be configured for the organization. Valid values: `NEW`, `ALL`, `NONE`.
 * @property name The name of the additional configuration that will be configured for the organization. Valid values: `EKS_ADDON_MANAGEMENT`.
 */
public data class OrganizationConfigurationFeatureAdditionalConfigurationArgs(
    public val autoEnable: Output<String>,
    public val name: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.guardduty.inputs.OrganizationConfigurationFeatureAdditionalConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.guardduty.inputs.OrganizationConfigurationFeatureAdditionalConfigurationArgs =
        com.pulumi.aws.guardduty.inputs.OrganizationConfigurationFeatureAdditionalConfigurationArgs.builder()
            .autoEnable(autoEnable.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OrganizationConfigurationFeatureAdditionalConfigurationArgs].
 */
@PulumiTagMarker
public class OrganizationConfigurationFeatureAdditionalConfigurationArgsBuilder internal
constructor() {
    private var autoEnable: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The status of the additional configuration that will be configured for the organization. Valid values: `NEW`, `ALL`, `NONE`.
     */
    @JvmName("hqtysbarvotvhygw")
    public suspend fun autoEnable(`value`: Output<String>) {
        this.autoEnable = value
    }

    /**
     * @param value The name of the additional configuration that will be configured for the organization. Valid values: `EKS_ADDON_MANAGEMENT`.
     */
    @JvmName("cjeklejvrkjnlncq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The status of the additional configuration that will be configured for the organization. Valid values: `NEW`, `ALL`, `NONE`.
     */
    @JvmName("ssfjjlqffsdralgm")
    public suspend fun autoEnable(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoEnable = mapped
    }

    /**
     * @param value The name of the additional configuration that will be configured for the organization. Valid values: `EKS_ADDON_MANAGEMENT`.
     */
    @JvmName("qyybpnjjtipdlipl")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): OrganizationConfigurationFeatureAdditionalConfigurationArgs =
        OrganizationConfigurationFeatureAdditionalConfigurationArgs(
            autoEnable = autoEnable ?: throw PulumiNullFieldException("autoEnable"),
            name = name ?: throw PulumiNullFieldException("name"),
        )
}
