@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property kubernetes Configures [Kubernetes protection](https://docs.aws.amazon.com/guardduty/latest/ug/kubernetes-protection.html).
 * See Kubernetes and Kubernetes Audit Logs below for more details.
 * @property malwareProtection Configures [Malware Protection](https://docs.aws.amazon.com/guardduty/latest/ug/malware-protection.html).
 * See Malware Protection, Scan EC2 instance with findings and EBS volumes below for more details.
 * The `datasources` block is deprecated since March 2023. Use the `features` block instead and [map each `datasources` block to the corresponding `features` block](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty-feature-object-api-changes-march2023.html#guardduty-feature-enablement-datasource-relation).
 * @property s3Logs Configures [S3 protection](https://docs.aws.amazon.com/guardduty/latest/ug/s3-protection.html).
 * See S3 Logs below for more details.
 */
public data class DetectorDatasources(
    public val kubernetes: DetectorDatasourcesKubernetes? = null,
    public val malwareProtection: DetectorDatasourcesMalwareProtection? = null,
    public val s3Logs: DetectorDatasourcesS3Logs? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.guardduty.outputs.DetectorDatasources):
            DetectorDatasources = DetectorDatasources(
            kubernetes = javaType.kubernetes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.guardduty.kotlin.outputs.DetectorDatasourcesKubernetes.Companion.toKotlin(args0)
                })
            }).orElse(null),
            malwareProtection = javaType.malwareProtection().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.guardduty.kotlin.outputs.DetectorDatasourcesMalwareProtection.Companion.toKotlin(args0)
                })
            }).orElse(null),
            s3Logs = javaType.s3Logs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.guardduty.kotlin.outputs.DetectorDatasourcesS3Logs.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
