@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property equals List of string values to be evaluated.
 * @property field The name of the field to be evaluated. The full list of field names can be found in [AWS documentation](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_filter-findings.html#filter_criteria).
 * @property greaterThan A value to be evaluated. Accepts either an integer or a date in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
 * @property greaterThanOrEqual A value to be evaluated. Accepts either an integer or a date in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
 * @property lessThan A value to be evaluated. Accepts either an integer or a date in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
 * @property lessThanOrEqual A value to be evaluated. Accepts either an integer or a date in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
 * @property notEquals List of string values to be evaluated.
 */
public data class FilterFindingCriteriaCriterion(
    public val equals: List<String>? = null,
    public val `field`: String,
    public val greaterThan: String? = null,
    public val greaterThanOrEqual: String? = null,
    public val lessThan: String? = null,
    public val lessThanOrEqual: String? = null,
    public val notEquals: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.guardduty.outputs.FilterFindingCriteriaCriterion):
            FilterFindingCriteriaCriterion = FilterFindingCriteriaCriterion(
            equals = javaType.equals_().map({ args0 -> args0 }),
            `field` = javaType.`field`(),
            greaterThan = javaType.greaterThan().map({ args0 -> args0 }).orElse(null),
            greaterThanOrEqual = javaType.greaterThanOrEqual().map({ args0 -> args0 }).orElse(null),
            lessThan = javaType.lessThan().map({ args0 -> args0 }).orElse(null),
            lessThanOrEqual = javaType.lessThanOrEqual().map({ args0 -> args0 }).orElse(null),
            notEquals = javaType.notEquals().map({ args0 -> args0 }),
        )
    }
}
