@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property additionalConfigurations Additional feature configuration.
 * @property name The name of the detector feature.
 * @property status Current status of the detector.
 */
public data class GetDetectorFeature(
    public val additionalConfigurations: List<GetDetectorFeatureAdditionalConfiguration>,
    public val name: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.guardduty.outputs.GetDetectorFeature):
            GetDetectorFeature = GetDetectorFeature(
            additionalConfigurations = javaType.additionalConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.guardduty.kotlin.outputs.GetDetectorFeatureAdditionalConfiguration.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            status = javaType.status(),
        )
    }
}
