@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property auditLogs Enable Kubernetes Audit Logs Monitoring automatically for new member accounts. [Kubernetes protection](https://docs.aws.amazon.com/guardduty/latest/ug/kubernetes-protection.html).
 * See Kubernetes Audit Logs below for more details.
 */
public data class OrganizationConfigurationDatasourcesKubernetes(
    public val auditLogs: OrganizationConfigurationDatasourcesKubernetesAuditLogs,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.guardduty.outputs.OrganizationConfigurationDatasourcesKubernetes):
            OrganizationConfigurationDatasourcesKubernetes =
            OrganizationConfigurationDatasourcesKubernetes(
                auditLogs = javaType.auditLogs().let({ args0 ->
                    com.pulumi.aws.guardduty.kotlin.outputs.OrganizationConfigurationDatasourcesKubernetesAuditLogs.Companion.toKotlin(args0)
                }),
            )
    }
}
