@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property scanEc2InstanceWithFindings Configure whether [Malware Protection](https://docs.aws.amazon.com/guardduty/latest/ug/malware-protection.html) for EC2 instances with findings should be auto-enabled for new members joining the organization.
 * See Scan EC2 instance with findings below for more details.
 */
public data class OrganizationConfigurationDatasourcesMalwareProtection(
    public val scanEc2InstanceWithFindings:
    OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindings,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.guardduty.outputs.OrganizationConfigurationDatasourcesMalwareProtection):
            OrganizationConfigurationDatasourcesMalwareProtection =
            OrganizationConfigurationDatasourcesMalwareProtection(
                scanEc2InstanceWithFindings = javaType.scanEc2InstanceWithFindings().let({ args0 ->
                    com.pulumi.aws.guardduty.kotlin.outputs.OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindings.Companion.toKotlin(args0)
                }),
            )
    }
}
