@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AccessKey].
 */
@PulumiTagMarker
public class AccessKeyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccessKeyArgs = AccessKeyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccessKeyArgsBuilder.() -> Unit) {
        val builder = AccessKeyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AccessKey {
        val builtJavaResource = com.pulumi.aws.iam.AccessKey(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AccessKey(builtJavaResource)
    }
}

/**
 * Provides an IAM access key. This is a set of credentials that allow API requests to be made as an IAM user.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.User;
 * import com.pulumi.aws.iam.UserArgs;
 * import com.pulumi.aws.iam.AccessKey;
 * import com.pulumi.aws.iam.AccessKeyArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.UserPolicy;
 * import com.pulumi.aws.iam.UserPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lbUser = new User("lbUser", UserArgs.builder()
 *             .path("/system/")
 *             .build());
 *         var lbAccessKey = new AccessKey("lbAccessKey", AccessKeyArgs.builder()
 *             .user(lbUser.name())
 *             .pgpKey("keybase:some_person_that_exists")
 *             .build());
 *         final var lbRoPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("ec2:Describe*")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var lbRoUserPolicy = new UserPolicy("lbRoUserPolicy", UserPolicyArgs.builder()
 *             .user(lbUser.name())
 *             .policy(lbRoPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         ctx.export("secret", lbAccessKey.encryptedSecret());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IAM Access Keys using the identifier. For example:
 * ```sh
 *  $ pulumi import aws:iam/accessKey:AccessKey example AKIA1234567890
 * ```
 *  Resource attributes such as `encrypted_secret`, `key_fingerprint`, `pgp_key`, `secret`, `ses_smtp_password_v4`, and `encrypted_ses_smtp_password_v4` are not available for imported resources as this information cannot be read from the IAM API.
 */
public class AccessKey internal constructor(
    override val javaResource: com.pulumi.aws.iam.AccessKey,
) : KotlinCustomResource(javaResource, AccessKeyMapper) {
    /**
     * Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the access key was created.
     */
    public val createDate: Output<String>
        get() = javaResource.createDate().applyValue({ args0 -> args0 })

    /**
     * Encrypted secret, base64 encoded, if `pgp_key` was specified. This attribute is not available for imported resources. The encrypted secret may be decrypted using the command line.
     */
    public val encryptedSecret: Output<String>
        get() = javaResource.encryptedSecret().applyValue({ args0 -> args0 })

    /**
     * Encrypted SES SMTP password, base64 encoded, if `pgp_key` was specified. This attribute is not available for imported resources. The encrypted password may be decrypted using the command line.
     */
    public val encryptedSesSmtpPasswordV4: Output<String>
        get() = javaResource.encryptedSesSmtpPasswordV4().applyValue({ args0 -> args0 })

    /**
     * Fingerprint of the PGP key used to encrypt the secret. This attribute is not available for imported resources.
     */
    public val keyFingerprint: Output<String>
        get() = javaResource.keyFingerprint().applyValue({ args0 -> args0 })

    /**
     * Either a base-64 encoded PGP public key, or a keybase username in the form `keybase:some_person_that_exists`, for use in the `encrypted_secret` output attribute. If providing a base-64 encoded PGP public key, make sure to provide the "raw" version and not the "armored" one (e.g. avoid passing the `-a` option to `gpg --export`).
     */
    public val pgpKey: Output<String>?
        get() = javaResource.pgpKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Secret access key. This attribute is not available for imported resources. Note that this will be written to the state file. If you use this, please protect your backend state file judiciously. Alternatively, you may supply a `pgp_key` instead, which will prevent the secret from being stored in plaintext, at the cost of preventing the use of the secret key in automation.
     */
    public val secret: Output<String>
        get() = javaResource.secret().applyValue({ args0 -> args0 })

    /**
     * Secret access key converted into an SES SMTP password by applying [AWS's documented Sigv4 conversion algorithm](https://docs&#46;aws&#46;amazon&#46;com/ses/latest/DeveloperGuide/smtp-credentials&#46;html#smtp-credentials-convert)&#46; This attribute is not available for imported resources&#46; As SigV4 is region specific, valid Provider regions are `ap-south-1`, `ap-southeast-2`, `eu-central-1`, `eu-west-1`, `us-east-1` and `us-west-2`&#46; See current [AWS SES regions](https://docs.aws.amazon.com/general/latest/gr/rande.html#ses_region).
     */
    public val sesSmtpPasswordV4: Output<String>
        get() = javaResource.sesSmtpPasswordV4().applyValue({ args0 -> args0 })

    /**
     * Access key status to apply. Defaults to `Active`. Valid values are `Active` and `Inactive`.
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * IAM user to associate with this access key.
     */
    public val user: Output<String>
        get() = javaResource.user().applyValue({ args0 -> args0 })
}

public object AccessKeyMapper : ResourceMapper<AccessKey> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iam.AccessKey::class == javaResource::class

    override fun map(javaResource: Resource): AccessKey = AccessKey(
        javaResource as
            com.pulumi.aws.iam.AccessKey,
    )
}

/**
 * @see [AccessKey].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccessKey].
 */
public suspend fun accessKey(name: String, block: suspend AccessKeyResourceBuilder.() -> Unit):
    AccessKey {
    val builder = AccessKeyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccessKey].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accessKey(name: String): AccessKey {
    val builder = AccessKeyResourceBuilder()
    builder.name(name)
    return builder.build()
}
