@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.aws.iam.AccessKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an IAM access key. This is a set of credentials that allow API requests to be made as an IAM user.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.User;
 * import com.pulumi.aws.iam.UserArgs;
 * import com.pulumi.aws.iam.AccessKey;
 * import com.pulumi.aws.iam.AccessKeyArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.UserPolicy;
 * import com.pulumi.aws.iam.UserPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lbUser = new User("lbUser", UserArgs.builder()
 *             .path("/system/")
 *             .build());
 *         var lbAccessKey = new AccessKey("lbAccessKey", AccessKeyArgs.builder()
 *             .user(lbUser.name())
 *             .pgpKey("keybase:some_person_that_exists")
 *             .build());
 *         final var lbRoPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("ec2:Describe*")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var lbRoUserPolicy = new UserPolicy("lbRoUserPolicy", UserPolicyArgs.builder()
 *             .user(lbUser.name())
 *             .policy(lbRoPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         ctx.export("secret", lbAccessKey.encryptedSecret());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IAM Access Keys using the identifier. For example:
 * ```sh
 *  $ pulumi import aws:iam/accessKey:AccessKey example AKIA1234567890
 * ```
 *  Resource attributes such as `encrypted_secret`, `key_fingerprint`, `pgp_key`, `secret`, `ses_smtp_password_v4`, and `encrypted_ses_smtp_password_v4` are not available for imported resources as this information cannot be read from the IAM API.
 * @property pgpKey Either a base-64 encoded PGP public key, or a keybase username in the form `keybase:some_person_that_exists`, for use in the `encrypted_secret` output attribute. If providing a base-64 encoded PGP public key, make sure to provide the "raw" version and not the "armored" one (e.g. avoid passing the `-a` option to `gpg --export`).
 * @property status Access key status to apply. Defaults to `Active`. Valid values are `Active` and `Inactive`.
 * @property user IAM user to associate with this access key.
 */
public data class AccessKeyArgs(
    public val pgpKey: Output<String>? = null,
    public val status: Output<String>? = null,
    public val user: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.AccessKeyArgs> {
    override fun toJava(): com.pulumi.aws.iam.AccessKeyArgs =
        com.pulumi.aws.iam.AccessKeyArgs.builder()
            .pgpKey(pgpKey?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .user(user?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessKeyArgs].
 */
@PulumiTagMarker
public class AccessKeyArgsBuilder internal constructor() {
    private var pgpKey: Output<String>? = null

    private var status: Output<String>? = null

    private var user: Output<String>? = null

    /**
     * @param value Either a base-64 encoded PGP public key, or a keybase username in the form `keybase:some_person_that_exists`, for use in the `encrypted_secret` output attribute. If providing a base-64 encoded PGP public key, make sure to provide the "raw" version and not the "armored" one (e.g. avoid passing the `-a` option to `gpg --export`).
     */
    @JvmName("gghjwjbeoelirsvo")
    public suspend fun pgpKey(`value`: Output<String>) {
        this.pgpKey = value
    }

    /**
     * @param value Access key status to apply. Defaults to `Active`. Valid values are `Active` and `Inactive`.
     */
    @JvmName("vvwfenrascoluemh")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value IAM user to associate with this access key.
     */
    @JvmName("kdivfdlwpsxdrnjq")
    public suspend fun user(`value`: Output<String>) {
        this.user = value
    }

    /**
     * @param value Either a base-64 encoded PGP public key, or a keybase username in the form `keybase:some_person_that_exists`, for use in the `encrypted_secret` output attribute. If providing a base-64 encoded PGP public key, make sure to provide the "raw" version and not the "armored" one (e.g. avoid passing the `-a` option to `gpg --export`).
     */
    @JvmName("lmankiwirwmkmgqk")
    public suspend fun pgpKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pgpKey = mapped
    }

    /**
     * @param value Access key status to apply. Defaults to `Active`. Valid values are `Active` and `Inactive`.
     */
    @JvmName("bhnkhqjygkysufrk")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value IAM user to associate with this access key.
     */
    @JvmName("typdflgoiyouvuww")
    public suspend fun user(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.user = mapped
    }

    internal fun build(): AccessKeyArgs = AccessKeyArgs(
        pgpKey = pgpKey,
        status = status,
        user = user,
    )
}
