@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.aws.iam.AccountAliasArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * > **Note:** There is only a single account alias per AWS account.
 * Manages the account alias for the AWS Account.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.AccountAlias;
 * import com.pulumi.aws.iam.AccountAliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var alias = new AccountAlias("alias", AccountAliasArgs.builder()
 *             .accountAlias("my-account-alias")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import the current Account Alias using the `account_alias`. For example:
 * ```sh
 *  $ pulumi import aws:iam/accountAlias:AccountAlias alias my-account-alias
 * ```
 * @property accountAlias The account alias
 */
public data class AccountAliasArgs(
    public val accountAlias: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.AccountAliasArgs> {
    override fun toJava(): com.pulumi.aws.iam.AccountAliasArgs =
        com.pulumi.aws.iam.AccountAliasArgs.builder()
            .accountAlias(accountAlias?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccountAliasArgs].
 */
@PulumiTagMarker
public class AccountAliasArgsBuilder internal constructor() {
    private var accountAlias: Output<String>? = null

    /**
     * @param value The account alias
     */
    @JvmName("dnubyfklorxypvny")
    public suspend fun accountAlias(`value`: Output<String>) {
        this.accountAlias = value
    }

    /**
     * @param value The account alias
     */
    @JvmName("aqnrdbjrfdqyuhvi")
    public suspend fun accountAlias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountAlias = mapped
    }

    internal fun build(): AccountAliasArgs = AccountAliasArgs(
        accountAlias = accountAlias,
    )
}
