@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AccountPasswordPolicy].
 */
@PulumiTagMarker
public class AccountPasswordPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccountPasswordPolicyArgs = AccountPasswordPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccountPasswordPolicyArgsBuilder.() -> Unit) {
        val builder = AccountPasswordPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AccountPasswordPolicy {
        val builtJavaResource = com.pulumi.aws.iam.AccountPasswordPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AccountPasswordPolicy(builtJavaResource)
    }
}

/**
 * > **Note:** There is only a single policy allowed per AWS account. An existing policy will be lost when using this resource as an effect of this limitation.
 * Manages Password Policy for the AWS Account.
 * See more about [Account Password Policy](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_passwords_account-policy.html)
 * in the official AWS docs.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.AccountPasswordPolicy;
 * import com.pulumi.aws.iam.AccountPasswordPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var strict = new AccountPasswordPolicy("strict", AccountPasswordPolicyArgs.builder()
 *             .allowUsersToChangePassword(true)
 *             .minimumPasswordLength(8)
 *             .requireLowercaseCharacters(true)
 *             .requireNumbers(true)
 *             .requireSymbols(true)
 *             .requireUppercaseCharacters(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IAM Account Password Policy using the word `iam-account-password-policy`. For example:
 * ```sh
 *  $ pulumi import aws:iam/accountPasswordPolicy:AccountPasswordPolicy strict iam-account-password-policy
 * ```
 *
 */
public class AccountPasswordPolicy internal constructor(
    override val javaResource: com.pulumi.aws.iam.AccountPasswordPolicy,
) : KotlinCustomResource(javaResource, AccountPasswordPolicyMapper) {
    /**
     * Whether to allow users to change their own password
     */
    public val allowUsersToChangePassword: Output<Boolean>?
        get() = javaResource.allowUsersToChangePassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether passwords in the account expire. Returns `true` if `max_password_age` contains a value greater than `0`. Returns `false` if it is `0` or _not present_.
     */
    public val expirePasswords: Output<Boolean>
        get() = javaResource.expirePasswords().applyValue({ args0 -> args0 })

    /**
     * Whether users are prevented from setting a new password after their password has expired (i.e., require administrator reset)
     */
    public val hardExpiry: Output<Boolean>
        get() = javaResource.hardExpiry().applyValue({ args0 -> args0 })

    /**
     * The number of days that an user password is valid.
     */
    public val maxPasswordAge: Output<Int>
        get() = javaResource.maxPasswordAge().applyValue({ args0 -> args0 })

    /**
     * Minimum length to require for user passwords.
     */
    public val minimumPasswordLength: Output<Int>?
        get() = javaResource.minimumPasswordLength().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of previous passwords that users are prevented from reusing.
     */
    public val passwordReusePrevention: Output<Int>
        get() = javaResource.passwordReusePrevention().applyValue({ args0 -> args0 })

    /**
     * Whether to require lowercase characters for user passwords.
     */
    public val requireLowercaseCharacters: Output<Boolean>
        get() = javaResource.requireLowercaseCharacters().applyValue({ args0 -> args0 })

    /**
     * Whether to require numbers for user passwords.
     */
    public val requireNumbers: Output<Boolean>
        get() = javaResource.requireNumbers().applyValue({ args0 -> args0 })

    /**
     * Whether to require symbols for user passwords.
     */
    public val requireSymbols: Output<Boolean>
        get() = javaResource.requireSymbols().applyValue({ args0 -> args0 })

    /**
     * Whether to require uppercase characters for user passwords.
     */
    public val requireUppercaseCharacters: Output<Boolean>
        get() = javaResource.requireUppercaseCharacters().applyValue({ args0 -> args0 })
}

public object AccountPasswordPolicyMapper : ResourceMapper<AccountPasswordPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iam.AccountPasswordPolicy::class == javaResource::class

    override fun map(javaResource: Resource): AccountPasswordPolicy =
        AccountPasswordPolicy(javaResource as com.pulumi.aws.iam.AccountPasswordPolicy)
}

/**
 * @see [AccountPasswordPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccountPasswordPolicy].
 */
public suspend fun accountPasswordPolicy(
    name: String,
    block: suspend AccountPasswordPolicyResourceBuilder.() -> Unit,
): AccountPasswordPolicy {
    val builder = AccountPasswordPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccountPasswordPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accountPasswordPolicy(name: String): AccountPasswordPolicy {
    val builder = AccountPasswordPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
