@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.aws.iam.AccountPasswordPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * > **Note:** There is only a single policy allowed per AWS account. An existing policy will be lost when using this resource as an effect of this limitation.
 * Manages Password Policy for the AWS Account.
 * See more about [Account Password Policy](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_passwords_account-policy.html)
 * in the official AWS docs.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.AccountPasswordPolicy;
 * import com.pulumi.aws.iam.AccountPasswordPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var strict = new AccountPasswordPolicy("strict", AccountPasswordPolicyArgs.builder()
 *             .allowUsersToChangePassword(true)
 *             .minimumPasswordLength(8)
 *             .requireLowercaseCharacters(true)
 *             .requireNumbers(true)
 *             .requireSymbols(true)
 *             .requireUppercaseCharacters(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IAM Account Password Policy using the word `iam-account-password-policy`. For example:
 * ```sh
 *  $ pulumi import aws:iam/accountPasswordPolicy:AccountPasswordPolicy strict iam-account-password-policy
 * ```
 * @property allowUsersToChangePassword Whether to allow users to change their own password
 * @property hardExpiry Whether users are prevented from setting a new password after their password has expired (i.e., require administrator reset)
 * @property maxPasswordAge The number of days that an user password is valid.
 * @property minimumPasswordLength Minimum length to require for user passwords.
 * @property passwordReusePrevention The number of previous passwords that users are prevented from reusing.
 * @property requireLowercaseCharacters Whether to require lowercase characters for user passwords.
 * @property requireNumbers Whether to require numbers for user passwords.
 * @property requireSymbols Whether to require symbols for user passwords.
 * @property requireUppercaseCharacters Whether to require uppercase characters for user passwords.
 */
public data class AccountPasswordPolicyArgs(
    public val allowUsersToChangePassword: Output<Boolean>? = null,
    public val hardExpiry: Output<Boolean>? = null,
    public val maxPasswordAge: Output<Int>? = null,
    public val minimumPasswordLength: Output<Int>? = null,
    public val passwordReusePrevention: Output<Int>? = null,
    public val requireLowercaseCharacters: Output<Boolean>? = null,
    public val requireNumbers: Output<Boolean>? = null,
    public val requireSymbols: Output<Boolean>? = null,
    public val requireUppercaseCharacters: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.AccountPasswordPolicyArgs> {
    override fun toJava(): com.pulumi.aws.iam.AccountPasswordPolicyArgs =
        com.pulumi.aws.iam.AccountPasswordPolicyArgs.builder()
            .allowUsersToChangePassword(allowUsersToChangePassword?.applyValue({ args0 -> args0 }))
            .hardExpiry(hardExpiry?.applyValue({ args0 -> args0 }))
            .maxPasswordAge(maxPasswordAge?.applyValue({ args0 -> args0 }))
            .minimumPasswordLength(minimumPasswordLength?.applyValue({ args0 -> args0 }))
            .passwordReusePrevention(passwordReusePrevention?.applyValue({ args0 -> args0 }))
            .requireLowercaseCharacters(requireLowercaseCharacters?.applyValue({ args0 -> args0 }))
            .requireNumbers(requireNumbers?.applyValue({ args0 -> args0 }))
            .requireSymbols(requireSymbols?.applyValue({ args0 -> args0 }))
            .requireUppercaseCharacters(requireUppercaseCharacters?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccountPasswordPolicyArgs].
 */
@PulumiTagMarker
public class AccountPasswordPolicyArgsBuilder internal constructor() {
    private var allowUsersToChangePassword: Output<Boolean>? = null

    private var hardExpiry: Output<Boolean>? = null

    private var maxPasswordAge: Output<Int>? = null

    private var minimumPasswordLength: Output<Int>? = null

    private var passwordReusePrevention: Output<Int>? = null

    private var requireLowercaseCharacters: Output<Boolean>? = null

    private var requireNumbers: Output<Boolean>? = null

    private var requireSymbols: Output<Boolean>? = null

    private var requireUppercaseCharacters: Output<Boolean>? = null

    /**
     * @param value Whether to allow users to change their own password
     */
    @JvmName("kukqmbtifvcjmjqc")
    public suspend fun allowUsersToChangePassword(`value`: Output<Boolean>) {
        this.allowUsersToChangePassword = value
    }

    /**
     * @param value Whether users are prevented from setting a new password after their password has expired (i.e., require administrator reset)
     */
    @JvmName("bamofjcilrgquihk")
    public suspend fun hardExpiry(`value`: Output<Boolean>) {
        this.hardExpiry = value
    }

    /**
     * @param value The number of days that an user password is valid.
     */
    @JvmName("hindvphajplulckf")
    public suspend fun maxPasswordAge(`value`: Output<Int>) {
        this.maxPasswordAge = value
    }

    /**
     * @param value Minimum length to require for user passwords.
     */
    @JvmName("bsfgjnqnjfirikxl")
    public suspend fun minimumPasswordLength(`value`: Output<Int>) {
        this.minimumPasswordLength = value
    }

    /**
     * @param value The number of previous passwords that users are prevented from reusing.
     */
    @JvmName("vcwcecvxfubpgovp")
    public suspend fun passwordReusePrevention(`value`: Output<Int>) {
        this.passwordReusePrevention = value
    }

    /**
     * @param value Whether to require lowercase characters for user passwords.
     */
    @JvmName("uvouvrpmbrktfgau")
    public suspend fun requireLowercaseCharacters(`value`: Output<Boolean>) {
        this.requireLowercaseCharacters = value
    }

    /**
     * @param value Whether to require numbers for user passwords.
     */
    @JvmName("hpepkrsqchnhgsxi")
    public suspend fun requireNumbers(`value`: Output<Boolean>) {
        this.requireNumbers = value
    }

    /**
     * @param value Whether to require symbols for user passwords.
     */
    @JvmName("eeaymcjctjntyasf")
    public suspend fun requireSymbols(`value`: Output<Boolean>) {
        this.requireSymbols = value
    }

    /**
     * @param value Whether to require uppercase characters for user passwords.
     */
    @JvmName("phelnokbgtpgganu")
    public suspend fun requireUppercaseCharacters(`value`: Output<Boolean>) {
        this.requireUppercaseCharacters = value
    }

    /**
     * @param value Whether to allow users to change their own password
     */
    @JvmName("skelftorvulpvecu")
    public suspend fun allowUsersToChangePassword(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowUsersToChangePassword = mapped
    }

    /**
     * @param value Whether users are prevented from setting a new password after their password has expired (i.e., require administrator reset)
     */
    @JvmName("nynduvthflpneufo")
    public suspend fun hardExpiry(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hardExpiry = mapped
    }

    /**
     * @param value The number of days that an user password is valid.
     */
    @JvmName("cfrdvuvpyhxtxgeb")
    public suspend fun maxPasswordAge(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxPasswordAge = mapped
    }

    /**
     * @param value Minimum length to require for user passwords.
     */
    @JvmName("mqtitjkumasgnyij")
    public suspend fun minimumPasswordLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimumPasswordLength = mapped
    }

    /**
     * @param value The number of previous passwords that users are prevented from reusing.
     */
    @JvmName("ikuuhewkenuoyrnb")
    public suspend fun passwordReusePrevention(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordReusePrevention = mapped
    }

    /**
     * @param value Whether to require lowercase characters for user passwords.
     */
    @JvmName("uviofjfkxxhnkqep")
    public suspend fun requireLowercaseCharacters(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireLowercaseCharacters = mapped
    }

    /**
     * @param value Whether to require numbers for user passwords.
     */
    @JvmName("rucvoddxgksaramr")
    public suspend fun requireNumbers(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireNumbers = mapped
    }

    /**
     * @param value Whether to require symbols for user passwords.
     */
    @JvmName("kcabejbntdsodhlb")
    public suspend fun requireSymbols(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireSymbols = mapped
    }

    /**
     * @param value Whether to require uppercase characters for user passwords.
     */
    @JvmName("xtyphmnaichuatmn")
    public suspend fun requireUppercaseCharacters(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireUppercaseCharacters = mapped
    }

    internal fun build(): AccountPasswordPolicyArgs = AccountPasswordPolicyArgs(
        allowUsersToChangePassword = allowUsersToChangePassword,
        hardExpiry = hardExpiry,
        maxPasswordAge = maxPasswordAge,
        minimumPasswordLength = minimumPasswordLength,
        passwordReusePrevention = passwordReusePrevention,
        requireLowercaseCharacters = requireLowercaseCharacters,
        requireNumbers = requireNumbers,
        requireSymbols = requireSymbols,
        requireUppercaseCharacters = requireUppercaseCharacters,
    )
}
