@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.aws.iam.GroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an IAM group.
 * > **NOTE on user management:** Using `aws.iam.GroupMembership` or `aws.iam.UserGroupMembership` resources in addition to manually managing user/group membership using the console may lead to configuration drift or conflicts. For this reason, it's recommended to either manage membership entirely with the provider or entirely within the AWS console.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Group;
 * import com.pulumi.aws.iam.GroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var developers = new Group("developers", GroupArgs.builder()
 *             .path("/users/")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IAM Groups using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:iam/group:Group developers developers
 * ```
 * @property name The group's name. The name must consist of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: `=,.@-_.`. Group names are not distinguished by case. For example, you cannot create groups named both "ADMINS" and "admins".
 * @property path Path in which to create the group.
 */
public data class GroupArgs(
    public val name: Output<String>? = null,
    public val path: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.GroupArgs> {
    override fun toJava(): com.pulumi.aws.iam.GroupArgs = com.pulumi.aws.iam.GroupArgs.builder()
        .name(name?.applyValue({ args0 -> args0 }))
        .path(path?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupArgs].
 */
@PulumiTagMarker
public class GroupArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var path: Output<String>? = null

    /**
     * @param value The group's name. The name must consist of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: `=,.@-_.`. Group names are not distinguished by case. For example, you cannot create groups named both "ADMINS" and "admins".
     */
    @JvmName("bkwhqagprrfekven")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Path in which to create the group.
     */
    @JvmName("pkqmxmmyhurxyexv")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value The group's name. The name must consist of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: `=,.@-_.`. Group names are not distinguished by case. For example, you cannot create groups named both "ADMINS" and "admins".
     */
    @JvmName("caoyvtorgumshuax")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Path in which to create the group.
     */
    @JvmName("shawffkattnhjfir")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    internal fun build(): GroupArgs = GroupArgs(
        name = name,
        path = path,
    )
}
