@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [GroupMembership].
 */
@PulumiTagMarker
public class GroupMembershipResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GroupMembershipArgs = GroupMembershipArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GroupMembershipArgsBuilder.() -> Unit) {
        val builder = GroupMembershipArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): GroupMembership {
        val builtJavaResource = com.pulumi.aws.iam.GroupMembership(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GroupMembership(builtJavaResource)
    }
}

/**
 * > **WARNING:** Multiple aws.iam.GroupMembership resources with the same group name will produce inconsistent behavior!
 * Provides a top level resource to manage IAM Group membership for IAM Users. For
 * more information on managing IAM Groups or IAM Users, see IAM Groups or
 * IAM Users
 * > **Note:** `aws.iam.GroupMembership` will conflict with itself if used more than once with the same group. To non-exclusively manage the users in a group, see the
 * `aws.iam.UserGroupMembership` resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Group;
 * import com.pulumi.aws.iam.User;
 * import com.pulumi.aws.iam.GroupMembership;
 * import com.pulumi.aws.iam.GroupMembershipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var group = new Group("group");
 *         var userOne = new User("userOne");
 *         var userTwo = new User("userTwo");
 *         var team = new GroupMembership("team", GroupMembershipArgs.builder()
 *             .users(
 *                 userOne.name(),
 *                 userTwo.name())
 *             .group(group.name())
 *             .build());
 *     }
 * }
 * ```
 */
public class GroupMembership internal constructor(
    override val javaResource: com.pulumi.aws.iam.GroupMembership,
) : KotlinCustomResource(javaResource, GroupMembershipMapper) {
    /**
     * The IAM Group name to attach the list of `users` to
     */
    public val group: Output<String>
        get() = javaResource.group().applyValue({ args0 -> args0 })

    /**
     * The name to identify the Group Membership
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A list of IAM User names to associate with the Group
     */
    public val users: Output<List<String>>
        get() = javaResource.users().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object GroupMembershipMapper : ResourceMapper<GroupMembership> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iam.GroupMembership::class == javaResource::class

    override fun map(javaResource: Resource): GroupMembership = GroupMembership(
        javaResource as
            com.pulumi.aws.iam.GroupMembership,
    )
}

/**
 * @see [GroupMembership].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GroupMembership].
 */
public suspend fun groupMembership(
    name: String,
    block: suspend GroupMembershipResourceBuilder.() -> Unit,
): GroupMembership {
    val builder = GroupMembershipResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GroupMembership].
 * @param name The _unique_ name of the resulting resource.
 */
public fun groupMembership(name: String): GroupMembership {
    val builder = GroupMembershipResourceBuilder()
    builder.name(name)
    return builder.build()
}
