@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.aws.iam.GroupMembershipArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * > **WARNING:** Multiple aws.iam.GroupMembership resources with the same group name will produce inconsistent behavior!
 * Provides a top level resource to manage IAM Group membership for IAM Users. For
 * more information on managing IAM Groups or IAM Users, see IAM Groups or
 * IAM Users
 * > **Note:** `aws.iam.GroupMembership` will conflict with itself if used more than once with the same group. To non-exclusively manage the users in a group, see the
 * `aws.iam.UserGroupMembership` resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Group;
 * import com.pulumi.aws.iam.User;
 * import com.pulumi.aws.iam.GroupMembership;
 * import com.pulumi.aws.iam.GroupMembershipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var group = new Group("group");
 *         var userOne = new User("userOne");
 *         var userTwo = new User("userTwo");
 *         var team = new GroupMembership("team", GroupMembershipArgs.builder()
 *             .users(
 *                 userOne.name(),
 *                 userTwo.name())
 *             .group(group.name())
 *             .build());
 *     }
 * }
 * ```
 * @property group The IAM Group name to attach the list of `users` to
 * @property name The name to identify the Group Membership
 * @property users A list of IAM User names to associate with the Group
 */
public data class GroupMembershipArgs(
    public val group: Output<String>? = null,
    public val name: Output<String>? = null,
    public val users: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.GroupMembershipArgs> {
    override fun toJava(): com.pulumi.aws.iam.GroupMembershipArgs =
        com.pulumi.aws.iam.GroupMembershipArgs.builder()
            .group(group?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .users(users?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GroupMembershipArgs].
 */
@PulumiTagMarker
public class GroupMembershipArgsBuilder internal constructor() {
    private var group: Output<String>? = null

    private var name: Output<String>? = null

    private var users: Output<List<String>>? = null

    /**
     * @param value The IAM Group name to attach the list of `users` to
     */
    @JvmName("puokelacnnbrfutg")
    public suspend fun group(`value`: Output<String>) {
        this.group = value
    }

    /**
     * @param value The name to identify the Group Membership
     */
    @JvmName("bfoqysiihkmcjsvp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A list of IAM User names to associate with the Group
     */
    @JvmName("citqqoflfblthodn")
    public suspend fun users(`value`: Output<List<String>>) {
        this.users = value
    }

    @JvmName("swmpcgvqrglevqvg")
    public suspend fun users(vararg values: Output<String>) {
        this.users = Output.all(values.asList())
    }

    /**
     * @param values A list of IAM User names to associate with the Group
     */
    @JvmName("shcyewlkhjnjoyks")
    public suspend fun users(values: List<Output<String>>) {
        this.users = Output.all(values)
    }

    /**
     * @param value The IAM Group name to attach the list of `users` to
     */
    @JvmName("ekydftexnscycycw")
    public suspend fun group(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.group = mapped
    }

    /**
     * @param value The name to identify the Group Membership
     */
    @JvmName("wdwqipmbynugeqba")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A list of IAM User names to associate with the Group
     */
    @JvmName("ykouwbxnhafkixil")
    public suspend fun users(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.users = mapped
    }

    /**
     * @param values A list of IAM User names to associate with the Group
     */
    @JvmName("tmjhimxwkmfrdorp")
    public suspend fun users(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.users = mapped
    }

    internal fun build(): GroupMembershipArgs = GroupMembershipArgs(
        group = group,
        name = name,
        users = users,
    )
}
