@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [GroupPolicy].
 */
@PulumiTagMarker
public class GroupPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GroupPolicyArgs = GroupPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GroupPolicyArgsBuilder.() -> Unit) {
        val builder = GroupPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): GroupPolicy {
        val builtJavaResource = com.pulumi.aws.iam.GroupPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GroupPolicy(builtJavaResource)
    }
}

/**
 * Provides an IAM policy attached to a group.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Group;
 * import com.pulumi.aws.iam.GroupArgs;
 * import com.pulumi.aws.iam.GroupPolicy;
 * import com.pulumi.aws.iam.GroupPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myDevelopers = new Group("myDevelopers", GroupArgs.builder()
 *             .path("/users/")
 *             .build());
 *         var myDeveloperPolicy = new GroupPolicy("myDeveloperPolicy", GroupPolicyArgs.builder()
 *             .group(myDevelopers.name())
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", jsonArray("ec2:Describe*")),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Resource", "*")
 *                     )))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IAM Group Policies using the `group_name:group_policy_name`. For example:
 * ```sh
 *  $ pulumi import aws:iam/groupPolicy:GroupPolicy mypolicy group_of_mypolicy_name:mypolicy_name
 * ```
 *
 */
public class GroupPolicy internal constructor(
    override val javaResource: com.pulumi.aws.iam.GroupPolicy,
) : KotlinCustomResource(javaResource, GroupPolicyMapper) {
    /**
     * The IAM group to attach to the policy.
     */
    public val group: Output<String>
        get() = javaResource.group().applyValue({ args0 -> args0 })

    /**
     * The name of the policy. If omitted, the provider will
     * assign a random, unique name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique name beginning with the specified
     * prefix. Conflicts with `name`.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * The policy document. This is a JSON formatted string.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })
}

public object GroupPolicyMapper : ResourceMapper<GroupPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iam.GroupPolicy::class == javaResource::class

    override fun map(javaResource: Resource): GroupPolicy = GroupPolicy(
        javaResource as
            com.pulumi.aws.iam.GroupPolicy,
    )
}

/**
 * @see [GroupPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GroupPolicy].
 */
public suspend fun groupPolicy(name: String, block: suspend GroupPolicyResourceBuilder.() -> Unit):
    GroupPolicy {
    val builder = GroupPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GroupPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun groupPolicy(name: String): GroupPolicy {
    val builder = GroupPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
