@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.aws.iam.GroupPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an IAM policy attached to a group.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Group;
 * import com.pulumi.aws.iam.GroupArgs;
 * import com.pulumi.aws.iam.GroupPolicy;
 * import com.pulumi.aws.iam.GroupPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myDevelopers = new Group("myDevelopers", GroupArgs.builder()
 *             .path("/users/")
 *             .build());
 *         var myDeveloperPolicy = new GroupPolicy("myDeveloperPolicy", GroupPolicyArgs.builder()
 *             .group(myDevelopers.name())
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", jsonArray("ec2:Describe*")),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Resource", "*")
 *                     )))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IAM Group Policies using the `group_name:group_policy_name`. For example:
 * ```sh
 *  $ pulumi import aws:iam/groupPolicy:GroupPolicy mypolicy group_of_mypolicy_name:mypolicy_name
 * ```
 * @property group The IAM group to attach to the policy.
 * @property name The name of the policy. If omitted, the provider will
 * assign a random, unique name.
 * @property namePrefix Creates a unique name beginning with the specified
 * prefix. Conflicts with `name`.
 * @property policy The policy document. This is a JSON formatted string.
 */
public data class GroupPolicyArgs(
    public val group: Output<String>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val policy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.GroupPolicyArgs> {
    override fun toJava(): com.pulumi.aws.iam.GroupPolicyArgs =
        com.pulumi.aws.iam.GroupPolicyArgs.builder()
            .group(group?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupPolicyArgs].
 */
@PulumiTagMarker
public class GroupPolicyArgsBuilder internal constructor() {
    private var group: Output<String>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var policy: Output<String>? = null

    /**
     * @param value The IAM group to attach to the policy.
     */
    @JvmName("vrtweptysttsowob")
    public suspend fun group(`value`: Output<String>) {
        this.group = value
    }

    /**
     * @param value The name of the policy. If omitted, the provider will
     * assign a random, unique name.
     */
    @JvmName("ttkwkaxxtgxrxhmj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified
     * prefix. Conflicts with `name`.
     */
    @JvmName("cqydjpberlaaupfw")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value The policy document. This is a JSON formatted string.
     */
    @JvmName("jyxmcnlrlhpqcqaq")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The IAM group to attach to the policy.
     */
    @JvmName("xssldxcmbylxsvdk")
    public suspend fun group(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.group = mapped
    }

    /**
     * @param value The name of the policy. If omitted, the provider will
     * assign a random, unique name.
     */
    @JvmName("pbtcqjtxeqbvhpgj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified
     * prefix. Conflicts with `name`.
     */
    @JvmName("athyrpehiietxfet")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value The policy document. This is a JSON formatted string.
     */
    @JvmName("kbbmucaixqhgefym")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    internal fun build(): GroupPolicyArgs = GroupPolicyArgs(
        group = group,
        name = name,
        namePrefix = namePrefix,
        policy = policy,
    )
}
