@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.aws.iam.GroupPolicyAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Attaches a Managed IAM Policy to an IAM group
 * > **NOTE:** The usage of this resource conflicts with the `aws.iam.PolicyAttachment` resource and will permanently show a difference if both are defined.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Group;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import com.pulumi.aws.iam.GroupPolicyAttachment;
 * import com.pulumi.aws.iam.GroupPolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var group = new Group("group");
 *         var policy = new Policy("policy", PolicyArgs.builder()
 *             .description("A test policy")
 *             .policy("{ ... policy JSON ... }")
 *             .build());
 *         var test_attach = new GroupPolicyAttachment("test-attach", GroupPolicyAttachmentArgs.builder()
 *             .group(group.name())
 *             .policyArn(policy.arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IAM group policy attachments using the group name and policy arn separated by `/`. For example:
 * ```sh
 *  $ pulumi import aws:iam/groupPolicyAttachment:GroupPolicyAttachment test-attach test-group/arn:aws:iam::xxxxxxxxxxxx:policy/test-policy
 * ```
 * @property group The group the policy should be applied to
 * @property policyArn The ARN of the policy you want to apply
 */
public data class GroupPolicyAttachmentArgs(
    public val group: Output<String>? = null,
    public val policyArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.GroupPolicyAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.iam.GroupPolicyAttachmentArgs =
        com.pulumi.aws.iam.GroupPolicyAttachmentArgs.builder()
            .group(group?.applyValue({ args0 -> args0 }))
            .policyArn(policyArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupPolicyAttachmentArgs].
 */
@PulumiTagMarker
public class GroupPolicyAttachmentArgsBuilder internal constructor() {
    private var group: Output<String>? = null

    private var policyArn: Output<String>? = null

    /**
     * @param value The group the policy should be applied to
     */
    @JvmName("vucybquveblimaxi")
    public suspend fun group(`value`: Output<String>) {
        this.group = value
    }

    /**
     * @param value The ARN of the policy you want to apply
     */
    @JvmName("mcislomxxcqhcrid")
    public suspend fun policyArn(`value`: Output<String>) {
        this.policyArn = value
    }

    /**
     * @param value The group the policy should be applied to
     */
    @JvmName("ropldxppaphrbmvl")
    public suspend fun group(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.group = mapped
    }

    /**
     * @param value The ARN of the policy you want to apply
     */
    @JvmName("nwoktyaqrkcsedxf")
    public suspend fun policyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyArn = mapped
    }

    internal fun build(): GroupPolicyAttachmentArgs = GroupPolicyAttachmentArgs(
        group = group,
        policyArn = policyArn,
    )
}
