@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.aws.iam.IamFunctions.getAccessKeysPlain
import com.pulumi.aws.iam.IamFunctions.getAccountAliasPlain
import com.pulumi.aws.iam.IamFunctions.getGroupPlain
import com.pulumi.aws.iam.IamFunctions.getInstanceProfilePlain
import com.pulumi.aws.iam.IamFunctions.getInstanceProfilesPlain
import com.pulumi.aws.iam.IamFunctions.getOpenIdConnectProviderPlain
import com.pulumi.aws.iam.IamFunctions.getPolicyDocumentPlain
import com.pulumi.aws.iam.IamFunctions.getPolicyPlain
import com.pulumi.aws.iam.IamFunctions.getPrincipalPolicySimulationPlain
import com.pulumi.aws.iam.IamFunctions.getRolePlain
import com.pulumi.aws.iam.IamFunctions.getRolesPlain
import com.pulumi.aws.iam.IamFunctions.getSamlProviderPlain
import com.pulumi.aws.iam.IamFunctions.getServerCertificatePlain
import com.pulumi.aws.iam.IamFunctions.getSessionContextPlain
import com.pulumi.aws.iam.IamFunctions.getUserPlain
import com.pulumi.aws.iam.IamFunctions.getUserSshKeyPlain
import com.pulumi.aws.iam.IamFunctions.getUsersPlain
import com.pulumi.aws.iam.kotlin.inputs.GetAccessKeysPlainArgs
import com.pulumi.aws.iam.kotlin.inputs.GetAccessKeysPlainArgsBuilder
import com.pulumi.aws.iam.kotlin.inputs.GetGroupPlainArgs
import com.pulumi.aws.iam.kotlin.inputs.GetGroupPlainArgsBuilder
import com.pulumi.aws.iam.kotlin.inputs.GetInstanceProfilePlainArgs
import com.pulumi.aws.iam.kotlin.inputs.GetInstanceProfilePlainArgsBuilder
import com.pulumi.aws.iam.kotlin.inputs.GetInstanceProfilesPlainArgs
import com.pulumi.aws.iam.kotlin.inputs.GetInstanceProfilesPlainArgsBuilder
import com.pulumi.aws.iam.kotlin.inputs.GetOpenIdConnectProviderPlainArgs
import com.pulumi.aws.iam.kotlin.inputs.GetOpenIdConnectProviderPlainArgsBuilder
import com.pulumi.aws.iam.kotlin.inputs.GetPolicyDocumentPlainArgs
import com.pulumi.aws.iam.kotlin.inputs.GetPolicyDocumentPlainArgsBuilder
import com.pulumi.aws.iam.kotlin.inputs.GetPolicyDocumentStatement
import com.pulumi.aws.iam.kotlin.inputs.GetPolicyPlainArgs
import com.pulumi.aws.iam.kotlin.inputs.GetPolicyPlainArgsBuilder
import com.pulumi.aws.iam.kotlin.inputs.GetPrincipalPolicySimulationContext
import com.pulumi.aws.iam.kotlin.inputs.GetPrincipalPolicySimulationPlainArgs
import com.pulumi.aws.iam.kotlin.inputs.GetPrincipalPolicySimulationPlainArgsBuilder
import com.pulumi.aws.iam.kotlin.inputs.GetRolePlainArgs
import com.pulumi.aws.iam.kotlin.inputs.GetRolePlainArgsBuilder
import com.pulumi.aws.iam.kotlin.inputs.GetRolesPlainArgs
import com.pulumi.aws.iam.kotlin.inputs.GetRolesPlainArgsBuilder
import com.pulumi.aws.iam.kotlin.inputs.GetSamlProviderPlainArgs
import com.pulumi.aws.iam.kotlin.inputs.GetSamlProviderPlainArgsBuilder
import com.pulumi.aws.iam.kotlin.inputs.GetServerCertificatePlainArgs
import com.pulumi.aws.iam.kotlin.inputs.GetServerCertificatePlainArgsBuilder
import com.pulumi.aws.iam.kotlin.inputs.GetSessionContextPlainArgs
import com.pulumi.aws.iam.kotlin.inputs.GetSessionContextPlainArgsBuilder
import com.pulumi.aws.iam.kotlin.inputs.GetUserPlainArgs
import com.pulumi.aws.iam.kotlin.inputs.GetUserPlainArgsBuilder
import com.pulumi.aws.iam.kotlin.inputs.GetUserSshKeyPlainArgs
import com.pulumi.aws.iam.kotlin.inputs.GetUserSshKeyPlainArgsBuilder
import com.pulumi.aws.iam.kotlin.inputs.GetUsersPlainArgs
import com.pulumi.aws.iam.kotlin.inputs.GetUsersPlainArgsBuilder
import com.pulumi.aws.iam.kotlin.outputs.GetAccessKeysResult
import com.pulumi.aws.iam.kotlin.outputs.GetAccountAliasResult
import com.pulumi.aws.iam.kotlin.outputs.GetGroupResult
import com.pulumi.aws.iam.kotlin.outputs.GetInstanceProfileResult
import com.pulumi.aws.iam.kotlin.outputs.GetInstanceProfilesResult
import com.pulumi.aws.iam.kotlin.outputs.GetOpenIdConnectProviderResult
import com.pulumi.aws.iam.kotlin.outputs.GetPolicyDocumentResult
import com.pulumi.aws.iam.kotlin.outputs.GetPolicyResult
import com.pulumi.aws.iam.kotlin.outputs.GetPrincipalPolicySimulationInvokeResult
import com.pulumi.aws.iam.kotlin.outputs.GetRoleResult
import com.pulumi.aws.iam.kotlin.outputs.GetRolesResult
import com.pulumi.aws.iam.kotlin.outputs.GetSamlProviderResult
import com.pulumi.aws.iam.kotlin.outputs.GetServerCertificateResult
import com.pulumi.aws.iam.kotlin.outputs.GetSessionContextResult
import com.pulumi.aws.iam.kotlin.outputs.GetUserResult
import com.pulumi.aws.iam.kotlin.outputs.GetUserSshKeyResult
import com.pulumi.aws.iam.kotlin.outputs.GetUsersResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.iam.kotlin.outputs.GetAccessKeysResult.Companion.toKotlin as getAccessKeysResultToKotlin
import com.pulumi.aws.iam.kotlin.outputs.GetAccountAliasResult.Companion.toKotlin as getAccountAliasResultToKotlin
import com.pulumi.aws.iam.kotlin.outputs.GetGroupResult.Companion.toKotlin as getGroupResultToKotlin
import com.pulumi.aws.iam.kotlin.outputs.GetInstanceProfileResult.Companion.toKotlin as getInstanceProfileResultToKotlin
import com.pulumi.aws.iam.kotlin.outputs.GetInstanceProfilesResult.Companion.toKotlin as getInstanceProfilesResultToKotlin
import com.pulumi.aws.iam.kotlin.outputs.GetOpenIdConnectProviderResult.Companion.toKotlin as getOpenIdConnectProviderResultToKotlin
import com.pulumi.aws.iam.kotlin.outputs.GetPolicyDocumentResult.Companion.toKotlin as getPolicyDocumentResultToKotlin
import com.pulumi.aws.iam.kotlin.outputs.GetPolicyResult.Companion.toKotlin as getPolicyResultToKotlin
import com.pulumi.aws.iam.kotlin.outputs.GetPrincipalPolicySimulationInvokeResult.Companion.toKotlin as getPrincipalPolicySimulationInvokeResultToKotlin
import com.pulumi.aws.iam.kotlin.outputs.GetRoleResult.Companion.toKotlin as getRoleResultToKotlin
import com.pulumi.aws.iam.kotlin.outputs.GetRolesResult.Companion.toKotlin as getRolesResultToKotlin
import com.pulumi.aws.iam.kotlin.outputs.GetSamlProviderResult.Companion.toKotlin as getSamlProviderResultToKotlin
import com.pulumi.aws.iam.kotlin.outputs.GetServerCertificateResult.Companion.toKotlin as getServerCertificateResultToKotlin
import com.pulumi.aws.iam.kotlin.outputs.GetSessionContextResult.Companion.toKotlin as getSessionContextResultToKotlin
import com.pulumi.aws.iam.kotlin.outputs.GetUserResult.Companion.toKotlin as getUserResultToKotlin
import com.pulumi.aws.iam.kotlin.outputs.GetUserSshKeyResult.Companion.toKotlin as getUserSshKeyResultToKotlin
import com.pulumi.aws.iam.kotlin.outputs.GetUsersResult.Companion.toKotlin as getUsersResultToKotlin

public object IamFunctions {
    /**
     * This data source can be used to fetch information about IAM access keys of a
     * specific IAM user.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetAccessKeysArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = IamFunctions.getAccessKeys(GetAccessKeysArgs.builder()
     *             .user("an_example_user_name")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getAccessKeys.
     * @return A collection of values returned by getAccessKeys.
     */
    public suspend fun getAccessKeys(argument: GetAccessKeysPlainArgs): GetAccessKeysResult =
        getAccessKeysResultToKotlin(getAccessKeysPlain(argument.toJava()).await())

    /**
     * @see [getAccessKeys].
     * @param user Name of the IAM user associated with the access keys.
     * @return A collection of values returned by getAccessKeys.
     */
    public suspend fun getAccessKeys(user: String): GetAccessKeysResult {
        val argument = GetAccessKeysPlainArgs(
            user = user,
        )
        return getAccessKeysResultToKotlin(getAccessKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccessKeys].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;iam&#46;kotlin&#46;inputs&#46;GetAccessKeysPlainArgs].
     * @return A collection of values returned by getAccessKeys.
     */
    public suspend fun getAccessKeys(argument: suspend GetAccessKeysPlainArgsBuilder.() -> Unit):
        GetAccessKeysResult {
        val builder = GetAccessKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccessKeysResultToKotlin(getAccessKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * The IAM Account Alias data source allows access to the account alias
     * for the effective account in which this provider is working.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = IamFunctions.getAccountAlias();
     *         ctx.export("accountId", current.applyValue(getAccountAliasResult -> getAccountAliasResult.accountAlias()));
     *     }
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = IamFunctions.getAccountAlias();
     *         ctx.export("accountId", current.applyValue(getAccountAliasResult -> getAccountAliasResult.accountAlias()));
     *     }
     * }
     * ```
     * @param argument The IAM Account Alias data source allows access to the account alias
     * for the effective account in which this provider is working.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = IamFunctions.getAccountAlias();
     *         ctx.export("accountId", current.applyValue(getAccountAliasResult -> getAccountAliasResult.accountAlias()));
     *     }
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = IamFunctions.getAccountAlias();
     *         ctx.export("accountId", current.applyValue(getAccountAliasResult -> getAccountAliasResult.accountAlias()));
     *     }
     * }
     * ```
     * @return A collection of values returned by getAccountAlias.
     */
    public suspend fun getAccountAlias(): GetAccountAliasResult =
        getAccountAliasResultToKotlin(getAccountAliasPlain().await())

    /**
     * This data source can be used to fetch information about a specific
     * IAM group. By using this data source, you can reference IAM group
     * properties without having to hard code ARNs as input.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = IamFunctions.getGroup(GetGroupArgs.builder()
     *             .groupName("an_example_group_name")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getGroup.
     * @return A collection of values returned by getGroup.
     */
    public suspend fun getGroup(argument: GetGroupPlainArgs): GetGroupResult =
        getGroupResultToKotlin(getGroupPlain(argument.toJava()).await())

    /**
     * @see [getGroup].
     * @param groupName Friendly IAM group name to match.
     * @return A collection of values returned by getGroup.
     */
    public suspend fun getGroup(groupName: String): GetGroupResult {
        val argument = GetGroupPlainArgs(
            groupName = groupName,
        )
        return getGroupResultToKotlin(getGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getGroup].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;iam&#46;kotlin&#46;inputs&#46;GetGroupPlainArgs].
     * @return A collection of values returned by getGroup.
     */
    public suspend fun getGroup(argument: suspend GetGroupPlainArgsBuilder.() -> Unit):
        GetGroupResult {
        val builder = GetGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGroupResultToKotlin(getGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source can be used to fetch information about a specific
     * IAM instance profile. By using this data source, you can reference IAM
     * instance profile properties without having to hard code ARNs as input.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetInstanceProfileArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = IamFunctions.getInstanceProfile(GetInstanceProfileArgs.builder()
     *             .name("an_example_instance_profile_name")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getInstanceProfile.
     * @return A collection of values returned by getInstanceProfile.
     */
    public suspend fun getInstanceProfile(argument: GetInstanceProfilePlainArgs):
        GetInstanceProfileResult =
        getInstanceProfileResultToKotlin(getInstanceProfilePlain(argument.toJava()).await())

    /**
     * @see [getInstanceProfile].
     * @param name Friendly IAM instance profile name to match.
     * @return A collection of values returned by getInstanceProfile.
     */
    public suspend fun getInstanceProfile(name: String): GetInstanceProfileResult {
        val argument = GetInstanceProfilePlainArgs(
            name = name,
        )
        return getInstanceProfileResultToKotlin(getInstanceProfilePlain(argument.toJava()).await())
    }

    /**
     * @see [getInstanceProfile].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;iam&#46;kotlin&#46;inputs&#46;GetInstanceProfilePlainArgs].
     * @return A collection of values returned by getInstanceProfile.
     */
    public suspend
    fun getInstanceProfile(argument: suspend GetInstanceProfilePlainArgsBuilder.() -> Unit):
        GetInstanceProfileResult {
        val builder = GetInstanceProfilePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceProfileResultToKotlin(getInstanceProfilePlain(builtArgument.toJava()).await())
    }

    /**
     * This data source can be used to fetch information about all
     * IAM instance profiles under a role. By using this data source, you can reference IAM
     * instance profile properties without having to hard code ARNs as input.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetInstanceProfilesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = IamFunctions.getInstanceProfiles(GetInstanceProfilesArgs.builder()
     *             .roleName("an_example_iam_role_name")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getInstanceProfiles.
     * @return A collection of values returned by getInstanceProfiles.
     */
    public suspend fun getInstanceProfiles(argument: GetInstanceProfilesPlainArgs):
        GetInstanceProfilesResult =
        getInstanceProfilesResultToKotlin(getInstanceProfilesPlain(argument.toJava()).await())

    /**
     * @see [getInstanceProfiles].
     * @param roleName IAM role name.
     * @return A collection of values returned by getInstanceProfiles.
     */
    public suspend fun getInstanceProfiles(roleName: String): GetInstanceProfilesResult {
        val argument = GetInstanceProfilesPlainArgs(
            roleName = roleName,
        )
        return getInstanceProfilesResultToKotlin(getInstanceProfilesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstanceProfiles].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;iam&#46;kotlin&#46;inputs&#46;GetInstanceProfilesPlainArgs].
     * @return A collection of values returned by getInstanceProfiles.
     */
    public suspend
    fun getInstanceProfiles(argument: suspend GetInstanceProfilesPlainArgsBuilder.() -> Unit):
        GetInstanceProfilesResult {
        val builder = GetInstanceProfilesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceProfilesResultToKotlin(getInstanceProfilesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source can be used to fetch information about a specific
     * IAM OpenID Connect provider. By using this data source, you can retrieve the
     * the resource information by either its `arn` or `url`.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetOpenIdConnectProviderArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = IamFunctions.getOpenIdConnectProvider(GetOpenIdConnectProviderArgs.builder()
     *             .arn("arn:aws:iam::123456789012:oidc-provider/accounts.google.com")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getOpenIdConnectProvider.
     * @return A collection of values returned by getOpenIdConnectProvider.
     */
    public suspend fun getOpenIdConnectProvider(argument: GetOpenIdConnectProviderPlainArgs):
        GetOpenIdConnectProviderResult =
        getOpenIdConnectProviderResultToKotlin(getOpenIdConnectProviderPlain(argument.toJava()).await())

    /**
     * @see [getOpenIdConnectProvider].
     * @param arn ARN of the OpenID Connect provider.
     * @param tags Map of resource tags for the IAM OIDC provider.
     * @param url URL of the OpenID Connect provider.
     * @return A collection of values returned by getOpenIdConnectProvider.
     */
    public suspend fun getOpenIdConnectProvider(
        arn: String? = null,
        tags: Map<String, String>? = null,
        url: String? = null,
    ): GetOpenIdConnectProviderResult {
        val argument = GetOpenIdConnectProviderPlainArgs(
            arn = arn,
            tags = tags,
            url = url,
        )
        return getOpenIdConnectProviderResultToKotlin(getOpenIdConnectProviderPlain(argument.toJava()).await())
    }

    /**
     * @see [getOpenIdConnectProvider].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;iam&#46;kotlin&#46;inputs&#46;GetOpenIdConnectProviderPlainArgs].
     * @return A collection of values returned by getOpenIdConnectProvider.
     */
    public suspend
    fun getOpenIdConnectProvider(argument: suspend GetOpenIdConnectProviderPlainArgsBuilder.() -> Unit):
        GetOpenIdConnectProviderResult {
        val builder = GetOpenIdConnectProviderPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOpenIdConnectProviderResultToKotlin(getOpenIdConnectProviderPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source can be used to fetch information about a specific
     * IAM policy.
     * ## Example Usage
     * ### By ARN
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = IamFunctions.getPolicy(GetPolicyArgs.builder()
     *             .arn("arn:aws:iam::123456789012:policy/UsersManageOwnCredentials")
     *             .build());
     *     }
     * }
     * ```
     * ### By Name
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = IamFunctions.getPolicy(GetPolicyArgs.builder()
     *             .name("test_policy")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getPolicy.
     * @return A collection of values returned by getPolicy.
     */
    public suspend fun getPolicy(argument: GetPolicyPlainArgs): GetPolicyResult =
        getPolicyResultToKotlin(getPolicyPlain(argument.toJava()).await())

    /**
     * @see [getPolicy].
     * @param arn ARN of the IAM policy.
     * Conflicts with `name` and `path_prefix`.
     * @param name Name of the IAM policy.
     * Conflicts with `arn`.
     * @param pathPrefix Prefix of the path to the IAM policy.
     * Defaults to a slash (`/`).
     * Conflicts with `arn`.
     * @param tags Key-value mapping of tags for the IAM Policy.
     * @return A collection of values returned by getPolicy.
     */
    public suspend fun getPolicy(
        arn: String? = null,
        name: String? = null,
        pathPrefix: String? = null,
        tags: Map<String, String>? = null,
    ): GetPolicyResult {
        val argument = GetPolicyPlainArgs(
            arn = arn,
            name = name,
            pathPrefix = pathPrefix,
            tags = tags,
        )
        return getPolicyResultToKotlin(getPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;iam&#46;kotlin&#46;inputs&#46;GetPolicyPlainArgs].
     * @return A collection of values returned by getPolicy.
     */
    public suspend fun getPolicy(argument: suspend GetPolicyPlainArgsBuilder.() -> Unit):
        GetPolicyResult {
        val builder = GetPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPolicyResultToKotlin(getPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Generates an IAM policy document in JSON format for use with resources that expect policy documents such as `aws.iam.Policy`.
     * Using this data source to generate policy documents is *optional*. It is also valid to use literal JSON strings in your configuration or to use the `file` interpolation function to read a raw JSON policy document from a file.
     * ## Example Usage
     * ### Basic Example
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import com.pulumi.aws.iam.Policy;
     * import com.pulumi.aws.iam.PolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .sid("1")
     *                     .actions(
     *                         "s3:ListAllMyBuckets",
     *                         "s3:GetBucketLocation")
     *                     .resources("arn:aws:s3:::*")
     *                     .build(),
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .actions("s3:ListBucket")
     *                     .resources(String.format("arn:aws:s3:::%s", var_.s3_bucket_name()))
     *                     .conditions(GetPolicyDocumentStatementConditionArgs.builder()
     *                         .test("StringLike")
     *                         .variable("s3:prefix")
     *                         .values(
     *                             "",
     *                             "home/",
     *                             "home/&{aws:username}/")
     *                         .build())
     *                     .build(),
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .actions("s3:*")
     *                     .resources(
     *                         String.format("arn:aws:s3:::%s/home/&{{aws:username}}", var_.s3_bucket_name()),
     *                         String.format("arn:aws:s3:::%s/home/&{{aws:username}}/*", var_.s3_bucket_name()))
     *                     .build())
     *             .build());
     *         var examplePolicy = new Policy("examplePolicy", PolicyArgs.builder()
     *             .path("/")
     *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
     *             .build());
     *     }
     * }
     * ```
     * ### Example Multiple Condition Keys and Values
     * You can specify a [condition with multiple keys and values](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_multi-value-conditions.html) by supplying multiple `condition` blocks with the same `test` value, but differing `variable` and `values` values.
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var exampleMultipleConditionKeysAndValues = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(GetPolicyDocumentStatementArgs.builder()
     *                 .actions(
     *                     "kms:Decrypt",
     *                     "kms:GenerateDataKey")
     *                 .conditions(
     *                     GetPolicyDocumentStatementConditionArgs.builder()
     *                         .test("ForAnyValue:StringEquals")
     *                         .values("pi")
     *                         .variable("kms:EncryptionContext:service")
     *                         .build(),
     *                     GetPolicyDocumentStatementConditionArgs.builder()
     *                         .test("ForAnyValue:StringEquals")
     *                         .values("rds")
     *                         .variable("kms:EncryptionContext:aws:pi:service")
     *                         .build(),
     *                     GetPolicyDocumentStatementConditionArgs.builder()
     *                         .test("ForAnyValue:StringEquals")
     *                         .values(
     *                             "db-AAAAABBBBBCCCCCDDDDDEEEEE",
     *                             "db-EEEEEDDDDDCCCCCBBBBBAAAAA")
     *                         .variable("kms:EncryptionContext:aws:rds:db-id")
     *                         .build())
     *                 .resources("*")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ### Example Assume-Role Policy with Multiple Principals
     * You can specify multiple principal blocks with different types. You can also use this data source to generate an assume-role policy.
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var eventStreamBucketRoleAssumeRolePolicy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(GetPolicyDocumentStatementArgs.builder()
     *                 .actions("sts:AssumeRole")
     *                 .principals(
     *                     GetPolicyDocumentStatementPrincipalArgs.builder()
     *                         .type("Service")
     *                         .identifiers("firehose.amazonaws.com")
     *                         .build(),
     *                     GetPolicyDocumentStatementPrincipalArgs.builder()
     *                         .type("AWS")
     *                         .identifiers(var_.trusted_role_arn())
     *                         .build(),
     *                     GetPolicyDocumentStatementPrincipalArgs.builder()
     *                         .type("Federated")
     *                         .identifiers(
     *                             String.format("arn:aws:iam::%s:saml-provider/%s", var_.account_id(),var_.provider_name()),
     *                             "cognito-identity.amazonaws.com")
     *                         .build())
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ### Example Using A Source Document
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var source = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .actions("ec2:*")
     *                     .resources("*")
     *                     .build(),
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .sid("SidToOverride")
     *                     .actions("s3:*")
     *                     .resources("*")
     *                     .build())
     *             .build());
     *         final var sourceDocumentExample = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .sourcePolicyDocuments(source.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
     *             .statements(GetPolicyDocumentStatementArgs.builder()
     *                 .sid("SidToOverride")
     *                 .actions("s3:*")
     *                 .resources(
     *                     "arn:aws:s3:::somebucket",
     *                     "arn:aws:s3:::somebucket/*")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ### Example Using An Override Document
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var override = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(GetPolicyDocumentStatementArgs.builder()
     *                 .sid("SidToOverride")
     *                 .actions("s3:*")
     *                 .resources("*")
     *                 .build())
     *             .build());
     *         final var overridePolicyDocumentExample = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .overridePolicyDocuments(override.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
     *             .statements(
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .actions("ec2:*")
     *                     .resources("*")
     *                     .build(),
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .sid("SidToOverride")
     *                     .actions("s3:*")
     *                     .resources(
     *                         "arn:aws:s3:::somebucket",
     *                         "arn:aws:s3:::somebucket/*")
     *                     .build())
     *             .build());
     *     }
     * }
     * ```
     * ### Example with Both Source and Override Documents
     * You can also combine `source_policy_documents` and `override_policy_documents` in the same document.
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var source = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(GetPolicyDocumentStatementArgs.builder()
     *                 .sid("OverridePlaceholder")
     *                 .actions("ec2:DescribeAccountAttributes")
     *                 .resources("*")
     *                 .build())
     *             .build());
     *         final var override = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(GetPolicyDocumentStatementArgs.builder()
     *                 .sid("OverridePlaceholder")
     *                 .actions("s3:GetObject")
     *                 .resources("*")
     *                 .build())
     *             .build());
     *         final var politik = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .sourcePolicyDocuments(source.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
     *             .overridePolicyDocuments(override.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
     *             .build());
     *     }
     * }
     * ```
     * ### Example of Merging Source Documents
     * Multiple documents can be combined using the `source_policy_documents` or `override_policy_documents` attributes. `source_policy_documents` requires that all documents have unique Sids, while `override_policy_documents` will iteratively override matching Sids.
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var sourceOne = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .actions("ec2:*")
     *                     .resources("*")
     *                     .build(),
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .sid("UniqueSidOne")
     *                     .actions("s3:*")
     *                     .resources("*")
     *                     .build())
     *             .build());
     *         final var sourceTwo = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .sid("UniqueSidTwo")
     *                     .actions("iam:*")
     *                     .resources("*")
     *                     .build(),
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .actions("lambda:*")
     *                     .resources("*")
     *                     .build())
     *             .build());
     *         final var combined = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .sourcePolicyDocuments(
     *                 sourceOne.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()),
     *                 sourceTwo.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
     *             .build());
     *     }
     * }
     * ```
     * ### Example of Merging Override Documents
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var policyOne = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(GetPolicyDocumentStatementArgs.builder()
     *                 .sid("OverridePlaceHolderOne")
     *                 .effect("Allow")
     *                 .actions("s3:*")
     *                 .resources("*")
     *                 .build())
     *             .build());
     *         final var policyTwo = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .effect("Allow")
     *                     .actions("ec2:*")
     *                     .resources("*")
     *                     .build(),
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .sid("OverridePlaceHolderTwo")
     *                     .effect("Allow")
     *                     .actions("iam:*")
     *                     .resources("*")
     *                     .build())
     *             .build());
     *         final var policyThree = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(GetPolicyDocumentStatementArgs.builder()
     *                 .sid("OverridePlaceHolderOne")
     *                 .effect("Deny")
     *                 .actions("logs:*")
     *                 .resources("*")
     *                 .build())
     *             .build());
     *         final var combined = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .overridePolicyDocuments(
     *                 policyOne.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()),
     *                 policyTwo.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()),
     *                 policyThree.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
     *             .statements(GetPolicyDocumentStatementArgs.builder()
     *                 .sid("OverridePlaceHolderTwo")
     *                 .effect("Deny")
     *                 .actions("*")
     *                 .resources("*")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getPolicyDocument.
     * @return A collection of values returned by getPolicyDocument.
     * */*/*/
     */
    public suspend fun getPolicyDocument(argument: GetPolicyDocumentPlainArgs):
        GetPolicyDocumentResult =
        getPolicyDocumentResultToKotlin(getPolicyDocumentPlain(argument.toJava()).await())

    /**
     * @see [getPolicyDocument].
     * @param overridePolicyDocuments List of IAM policy documents that are merged together into the exported document. In merging, statements with non-blank `sid`s will override statements with the same `sid` from earlier documents in the list. Statements with non-blank `sid`s will also override statements with the same `sid` from `source_policy_documents`.  Non-overriding statements will be added to the exported document.
     * @param policyId ID for the policy document.
     * @param sourcePolicyDocuments List of IAM policy documents that are merged together into the exported document. Statements defined in `source_policy_documents` must have unique `sid`s. Statements with the same `sid` from `override_policy_documents` will override source statements.
     * @param statements Configuration block for a policy statement. Detailed below.
     * @param version IAM policy document version. Valid values are `2008-10-17` and `2012-10-17`. Defaults to `2012-10-17`. For more information, see the [AWS IAM User Guide](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_version.html).
     * @return A collection of values returned by getPolicyDocument.
     */
    public suspend fun getPolicyDocument(
        overridePolicyDocuments: List<String>? = null,
        policyId: String? = null,
        sourcePolicyDocuments: List<String>? = null,
        statements: List<GetPolicyDocumentStatement>? = null,
        version: String? = null,
    ): GetPolicyDocumentResult {
        val argument = GetPolicyDocumentPlainArgs(
            overridePolicyDocuments = overridePolicyDocuments,
            policyId = policyId,
            sourcePolicyDocuments = sourcePolicyDocuments,
            statements = statements,
            version = version,
        )
        return getPolicyDocumentResultToKotlin(getPolicyDocumentPlain(argument.toJava()).await())
    }

    /**
     * @see [getPolicyDocument].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;iam&#46;kotlin&#46;inputs&#46;GetPolicyDocumentPlainArgs].
     * @return A collection of values returned by getPolicyDocument.
     */
    public suspend
    fun getPolicyDocument(argument: suspend GetPolicyDocumentPlainArgsBuilder.() -> Unit):
        GetPolicyDocumentResult {
        val builder = GetPolicyDocumentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPolicyDocumentResultToKotlin(getPolicyDocumentPlain(builtArgument.toJava()).await())
    }

    /**
     * Runs a simulation of the IAM policies of a particular principal against a given hypothetical request.
     * You can use this data source in conjunction with
     * Preconditions and Postconditions so that your configuration can test either whether it should have sufficient access to do its own work, or whether policies your configuration declares itself are sufficient for their intended use elsewhere.
     * > **Note:** Correctly using this data source requires familiarity with various details of AWS Identity and Access Management, and how various AWS services integrate with it. For general information on the AWS IAM policy simulator, see [Testing IAM policies with the IAM policy simulator](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_testing-policies.html). This data source wraps the `iam:SimulatePrincipalPolicy` API action described on that page.
     * {{% examples %}}
     * ## Example Usage
     * {{% /examples %}}
     * @param argument A collection of arguments for invoking getPrincipalPolicySimulation.
     * @return A collection of values returned by getPrincipalPolicySimulation.
     */
    public suspend fun getPrincipalPolicySimulation(argument: GetPrincipalPolicySimulationPlainArgs):
        GetPrincipalPolicySimulationInvokeResult =
        getPrincipalPolicySimulationInvokeResultToKotlin(getPrincipalPolicySimulationPlain(argument.toJava()).await())

    /**
     * @see [getPrincipalPolicySimulation].
     * @param actionNames A set of IAM action names to run simulations for. Each entry in this set adds an additional hypothetical request to the simulation.
     * Action names consist of a service prefix and an action verb separated by a colon, such as `s3:GetObject`. Refer to [Actions, resources, and condition keys for AWS services](https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html) to see the full set of possible IAM action names across all AWS services.
     * @param additionalPoliciesJsons A set of additional principal policy documents to include in the simulation. The simulator will behave as if each of these policies were associated with the object specified in `policy_source_arn`, allowing you to test the effect of hypothetical policies not yet created.
     * @param callerArn The ARN of an user that will appear as the "caller" of the simulated requests. If you do not specify `caller_arn` then the simulation will use the `policy_source_arn` instead, if it contains a user ARN.
     * @param contexts Each `context` block defines an entry in the table of additional context keys in the simulated request.
     * IAM uses context keys for both custom conditions and for interpolating dynamic request-specific values into policy values. If you use policies that include those features then you will need to provide suitable example values for those keys to achieve a realistic simulation.
     * @param permissionsBoundaryPoliciesJsons A set of [permissions boundary policy documents](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html) to include in the simulation.
     * @param policySourceArn The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the IAM user, group, or role whose policies will be included in the simulation.
     * You must closely match the form of the real service request you are simulating in order to achieve a realistic result. You can use the following additional arguments to specify other characteristics of the simulated requests:
     * @param resourceArns A set of ARNs of resources to include in the simulation.
     * This argument is important for actions that have either required or optional resource types listed in [Actions, resources, and condition keys for AWS services](https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html), and you must provide ARNs that identify AWS objects of the appropriate types for the chosen actions.
     * The policy simulator only automatically loads policies associated with the `policy_source_arn`, so if your given resources have their own resource-level policy then you'll also need to provide that explicitly using the `resource_policy_json` argument to achieve a realistic simulation.
     * @param resourceHandlingOption Specifies a special simulation type to run. Some EC2 actions require special simulation behaviors and a particular set of resource ARNs to achieve a realistic result.
     * For more details, see the `ResourceHandlingOption` request parameter for [the underlying `iam:SimulatePrincipalPolicy` action](https://docs.aws.amazon.com/IAM/latest/APIReference/API_SimulatePrincipalPolicy.html).
     * @param resourceOwnerAccountId An AWS account ID to use for any resource ARN in `resource_arns` that doesn't include its own AWS account ID. If unspecified, the simulator will use the account ID from the `caller_arn` argument as a placeholder.
     * @param resourcePolicyJson An IAM policy document representing the resource-level policy of all of the resources specified in `resource_arns`.
     * The policy simulator cannot automatically load policies that are associated with individual resources, as described in the documentation for `resource_arns` above.
     * @return A collection of values returned by getPrincipalPolicySimulation.
     */
    public suspend fun getPrincipalPolicySimulation(
        actionNames: List<String>,
        additionalPoliciesJsons: List<String>? = null,
        callerArn: String? = null,
        contexts: List<GetPrincipalPolicySimulationContext>? = null,
        permissionsBoundaryPoliciesJsons: List<String>? = null,
        policySourceArn: String,
        resourceArns: List<String>? = null,
        resourceHandlingOption: String? = null,
        resourceOwnerAccountId: String? = null,
        resourcePolicyJson: String? = null,
    ): GetPrincipalPolicySimulationInvokeResult {
        val argument = GetPrincipalPolicySimulationPlainArgs(
            actionNames = actionNames,
            additionalPoliciesJsons = additionalPoliciesJsons,
            callerArn = callerArn,
            contexts = contexts,
            permissionsBoundaryPoliciesJsons = permissionsBoundaryPoliciesJsons,
            policySourceArn = policySourceArn,
            resourceArns = resourceArns,
            resourceHandlingOption = resourceHandlingOption,
            resourceOwnerAccountId = resourceOwnerAccountId,
            resourcePolicyJson = resourcePolicyJson,
        )
        return getPrincipalPolicySimulationInvokeResultToKotlin(getPrincipalPolicySimulationPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrincipalPolicySimulation].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;iam&#46;kotlin&#46;inputs&#46;GetPrincipalPolicySimulationPlainArgs].
     * @return A collection of values returned by getPrincipalPolicySimulation.
     */
    public suspend
    fun getPrincipalPolicySimulation(argument: suspend GetPrincipalPolicySimulationPlainArgsBuilder.() -> Unit):
        GetPrincipalPolicySimulationInvokeResult {
        val builder = GetPrincipalPolicySimulationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrincipalPolicySimulationInvokeResultToKotlin(getPrincipalPolicySimulationPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source can be used to fetch information about a specific
     * IAM role. By using this data source, you can reference IAM role
     * properties without having to hard code ARNs as input.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetRoleArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = IamFunctions.getRole(GetRoleArgs.builder()
     *             .name("an_example_role_name")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getRole.
     * @return A collection of values returned by getRole.
     */
    public suspend fun getRole(argument: GetRolePlainArgs): GetRoleResult =
        getRoleResultToKotlin(getRolePlain(argument.toJava()).await())

    /**
     * @see [getRole].
     * @param name Friendly IAM role name to match.
     * @param tags Tags attached to the role.
     * @return A collection of values returned by getRole.
     */
    public suspend fun getRole(name: String, tags: Map<String, String>? = null): GetRoleResult {
        val argument = GetRolePlainArgs(
            name = name,
            tags = tags,
        )
        return getRoleResultToKotlin(getRolePlain(argument.toJava()).await())
    }

    /**
     * @see [getRole].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;iam&#46;kotlin&#46;inputs&#46;GetRolePlainArgs].
     * @return A collection of values returned by getRole.
     */
    public suspend fun getRole(argument: suspend GetRolePlainArgsBuilder.() -> Unit): GetRoleResult {
        val builder = GetRolePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRoleResultToKotlin(getRolePlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the ARNs and Names of IAM Roles.
     * ## Example Usage
     * ### All roles in an account
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetRolesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var roles = IamFunctions.getRoles();
     *     }
     * }
     * ```
     * ### Roles filtered by name regex
     * Roles whose role-name contains `project`
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetRolesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var roles = IamFunctions.getRoles(GetRolesArgs.builder()
     *             .nameRegex(".*project.*")
     *             .build());
     *     }
     * }
     * ```
     * ### Roles filtered by path prefix
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetRolesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var roles = IamFunctions.getRoles(GetRolesArgs.builder()
     *             .pathPrefix("/custom-path")
     *             .build());
     *     }
     * }
     * ```
     * ### Roles provisioned by AWS SSO
     * Roles in the account filtered by path prefix
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetRolesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var roles = IamFunctions.getRoles(GetRolesArgs.builder()
     *             .pathPrefix("/aws-reserved/sso.amazonaws.com/")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getRoles.
     * @return A collection of values returned by getRoles.
     */
    public suspend fun getRoles(argument: GetRolesPlainArgs): GetRolesResult =
        getRolesResultToKotlin(getRolesPlain(argument.toJava()).await())

    /**
     * @see [getRoles].
     * @param nameRegex Regex string to apply to the IAM roles list returned by AWS. This allows more advanced filtering not supported from the AWS API. This filtering is done locally on what AWS returns, and could have a performance impact if the result is large. Combine this with other options to narrow down the list AWS returns.
     * @param pathPrefix Path prefix for filtering the results. For example, the prefix `/application_abc/component_xyz/` gets all roles whose path starts with `/application_abc/component_xyz/`. If it is not included, it defaults to a slash (`/`), listing all roles. For more details, check out [list-roles in the AWS CLI reference][1].
     * @return A collection of values returned by getRoles.
     */
    public suspend fun getRoles(nameRegex: String? = null, pathPrefix: String? = null):
        GetRolesResult {
        val argument = GetRolesPlainArgs(
            nameRegex = nameRegex,
            pathPrefix = pathPrefix,
        )
        return getRolesResultToKotlin(getRolesPlain(argument.toJava()).await())
    }

    /**
     * @see [getRoles].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;iam&#46;kotlin&#46;inputs&#46;GetRolesPlainArgs].
     * @return A collection of values returned by getRoles.
     */
    public suspend fun getRoles(argument: suspend GetRolesPlainArgsBuilder.() -> Unit):
        GetRolesResult {
        val builder = GetRolesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRolesResultToKotlin(getRolesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source can be used to fetch information about a specific
     * IAM SAML provider. This will allow you to easily retrieve the metadata
     * document of an existing SAML provider.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetSamlProviderArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = IamFunctions.getSamlProvider(GetSamlProviderArgs.builder()
     *             .arn("arn:aws:iam::123456789:saml-provider/myprovider")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getSamlProvider.
     * @return A collection of values returned by getSamlProvider.
     */
    public suspend fun getSamlProvider(argument: GetSamlProviderPlainArgs): GetSamlProviderResult =
        getSamlProviderResultToKotlin(getSamlProviderPlain(argument.toJava()).await())

    /**
     * @see [getSamlProvider].
     * @param arn ARN assigned by AWS for the provider.
     * @param tags Tags attached to the SAML provider.
     * @return A collection of values returned by getSamlProvider.
     */
    public suspend fun getSamlProvider(arn: String, tags: Map<String, String>? = null):
        GetSamlProviderResult {
        val argument = GetSamlProviderPlainArgs(
            arn = arn,
            tags = tags,
        )
        return getSamlProviderResultToKotlin(getSamlProviderPlain(argument.toJava()).await())
    }

    /**
     * @see [getSamlProvider].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;iam&#46;kotlin&#46;inputs&#46;GetSamlProviderPlainArgs].
     * @return A collection of values returned by getSamlProvider.
     */
    public suspend fun getSamlProvider(argument: suspend GetSamlProviderPlainArgsBuilder.() -> Unit):
        GetSamlProviderResult {
        val builder = GetSamlProviderPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSamlProviderResultToKotlin(getSamlProviderPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to lookup information about IAM Server Certificates.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetServerCertificateArgs;
     * import com.pulumi.aws.elb.LoadBalancer;
     * import com.pulumi.aws.elb.LoadBalancerArgs;
     * import com.pulumi.aws.elb.inputs.LoadBalancerListenerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var my-domain = IamFunctions.getServerCertificate(GetServerCertificateArgs.builder()
     *             .namePrefix("my-domain.org")
     *             .latest(true)
     *             .build());
     *         var elb = new LoadBalancer("elb", LoadBalancerArgs.builder()
     *             .listeners(LoadBalancerListenerArgs.builder()
     *                 .instancePort(8000)
     *                 .instanceProtocol("https")
     *                 .lbPort(443)
     *                 .lbProtocol("https")
     *                 .sslCertificateId(my_domain.arn())
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getServerCertificate.
     * @return A collection of values returned by getServerCertificate.
     */
    public suspend fun getServerCertificate(argument: GetServerCertificatePlainArgs):
        GetServerCertificateResult =
        getServerCertificateResultToKotlin(getServerCertificatePlain(argument.toJava()).await())

    /**
     * @see [getServerCertificate].
     * @param latest sort results by expiration date. returns the certificate with expiration date in furthest in the future.
     * @param name exact name of the cert to lookup
     * @param namePrefix prefix of cert to filter by
     * @param pathPrefix prefix of path to filter by
     * @return A collection of values returned by getServerCertificate.
     */
    public suspend fun getServerCertificate(
        latest: Boolean? = null,
        name: String? = null,
        namePrefix: String? = null,
        pathPrefix: String? = null,
    ): GetServerCertificateResult {
        val argument = GetServerCertificatePlainArgs(
            latest = latest,
            name = name,
            namePrefix = namePrefix,
            pathPrefix = pathPrefix,
        )
        return getServerCertificateResultToKotlin(getServerCertificatePlain(argument.toJava()).await())
    }

    /**
     * @see [getServerCertificate].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;iam&#46;kotlin&#46;inputs&#46;GetServerCertificatePlainArgs].
     * @return A collection of values returned by getServerCertificate.
     */
    public suspend
    fun getServerCertificate(argument: suspend GetServerCertificatePlainArgsBuilder.() -> Unit):
        GetServerCertificateResult {
        val builder = GetServerCertificatePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerCertificateResultToKotlin(getServerCertificatePlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides information on the IAM source role of an STS assumed role. For non-role ARNs, this data source simply passes the ARN through in `issuer_arn`.
     * For some AWS resources, multiple types of principals are allowed in the same argument (e.g., IAM users and IAM roles). However, these arguments often do not allow assumed-role (i.e., STS, temporary credential) principals. Given an STS ARN, this data source provides the ARN for the source IAM role.
     * ## Example Usage
     * ### Basic Example
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetSessionContextArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = IamFunctions.getSessionContext(GetSessionContextArgs.builder()
     *             .arn("arn:aws:sts::123456789012:assumed-role/Audien-Heaven/MatyNoyes")
     *             .build());
     *     }
     * }
     * ```
     * ### Find the Runner's Source Role
     * Combined with `aws.getCallerIdentity`, you can get the current user's source IAM role ARN (`issuer_arn`) if you're using an assumed role. If you're not using an assumed role, the caller's (e.g., an IAM user's) ARN will simply be passed through. In environments where both IAM users and individuals using assumed roles need to apply the same configurations, this data source enables seamless use.
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetSessionContextArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getCallerIdentity();
     *         final var example = IamFunctions.getSessionContext(GetSessionContextArgs.builder()
     *             .arn(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.arn()))
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getSessionContext.
     * @return A collection of values returned by getSessionContext.
     */
    public suspend fun getSessionContext(argument: GetSessionContextPlainArgs):
        GetSessionContextResult =
        getSessionContextResultToKotlin(getSessionContextPlain(argument.toJava()).await())

    /**
     * @see [getSessionContext].
     * @param arn ARN for an assumed role.
     * > If `arn` is a non-role ARN, Pulumi gives no error and `issuer_arn` will be equal to the `arn` value. For STS assumed-role ARNs, Pulumi gives an error if the identified IAM role does not exist.
     * @return A collection of values returned by getSessionContext.
     */
    public suspend fun getSessionContext(arn: String): GetSessionContextResult {
        val argument = GetSessionContextPlainArgs(
            arn = arn,
        )
        return getSessionContextResultToKotlin(getSessionContextPlain(argument.toJava()).await())
    }

    /**
     * @see [getSessionContext].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;iam&#46;kotlin&#46;inputs&#46;GetSessionContextPlainArgs].
     * @return A collection of values returned by getSessionContext.
     */
    public suspend
    fun getSessionContext(argument: suspend GetSessionContextPlainArgsBuilder.() -> Unit):
        GetSessionContextResult {
        val builder = GetSessionContextPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSessionContextResultToKotlin(getSessionContextPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source can be used to fetch information about a specific
     * IAM user. By using this data source, you can reference IAM user
     * properties without having to hard code ARNs or unique IDs as input.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetUserArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = IamFunctions.getUser(GetUserArgs.builder()
     *             .userName("an_example_user_name")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getUser.
     * @return A collection of values returned by getUser.
     */
    public suspend fun getUser(argument: GetUserPlainArgs): GetUserResult =
        getUserResultToKotlin(getUserPlain(argument.toJava()).await())

    /**
     * @see [getUser].
     * @param tags Map of key-value pairs associated with the user.
     * @param userName Friendly IAM user name to match.
     * @return A collection of values returned by getUser.
     */
    public suspend fun getUser(tags: Map<String, String>? = null, userName: String): GetUserResult {
        val argument = GetUserPlainArgs(
            tags = tags,
            userName = userName,
        )
        return getUserResultToKotlin(getUserPlain(argument.toJava()).await())
    }

    /**
     * @see [getUser].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;iam&#46;kotlin&#46;inputs&#46;GetUserPlainArgs].
     * @return A collection of values returned by getUser.
     */
    public suspend fun getUser(argument: suspend GetUserPlainArgsBuilder.() -> Unit): GetUserResult {
        val builder = GetUserPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUserResultToKotlin(getUserPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get information about a SSH public key associated with the specified IAM user.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetUserSshKeyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = IamFunctions.getUserSshKey(GetUserSshKeyArgs.builder()
     *             .encoding("SSH")
     *             .sshPublicKeyId("APKARUZ32GUTKIGARLXE")
     *             .username("test-user")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getUserSshKey.
     * @return A collection of values returned by getUserSshKey.
     */
    public suspend fun getUserSshKey(argument: GetUserSshKeyPlainArgs): GetUserSshKeyResult =
        getUserSshKeyResultToKotlin(getUserSshKeyPlain(argument.toJava()).await())

    /**
     * @see [getUserSshKey].
     * @param encoding Specifies the public key encoding format to use in the response. To retrieve the public key in ssh-rsa format, use `SSH`. To retrieve the public key in PEM format, use `PEM`.
     * @param sshPublicKeyId Unique identifier for the SSH public key.
     * @param username Name of the IAM user associated with the SSH public key.
     * @return A collection of values returned by getUserSshKey.
     */
    public suspend fun getUserSshKey(
        encoding: String,
        sshPublicKeyId: String,
        username: String,
    ): GetUserSshKeyResult {
        val argument = GetUserSshKeyPlainArgs(
            encoding = encoding,
            sshPublicKeyId = sshPublicKeyId,
            username = username,
        )
        return getUserSshKeyResultToKotlin(getUserSshKeyPlain(argument.toJava()).await())
    }

    /**
     * @see [getUserSshKey].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;iam&#46;kotlin&#46;inputs&#46;GetUserSshKeyPlainArgs].
     * @return A collection of values returned by getUserSshKey.
     */
    public suspend fun getUserSshKey(argument: suspend GetUserSshKeyPlainArgsBuilder.() -> Unit):
        GetUserSshKeyResult {
        val builder = GetUserSshKeyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUserSshKeyResultToKotlin(getUserSshKeyPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the ARNs and Names of IAM Users.
     * ## Example Usage
     * ### All users in an account
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetUsersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var users = IamFunctions.getUsers();
     *     }
     * }
     * ```
     * ### Users filtered by name regex
     * Users whose username contains `abc`
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetUsersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var users = IamFunctions.getUsers(GetUsersArgs.builder()
     *             .nameRegex(".*abc.*")
     *             .build());
     *     }
     * }
     * ```
     * ### Users filtered by path prefix
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetUsersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var users = IamFunctions.getUsers(GetUsersArgs.builder()
     *             .pathPrefix("/custom-path")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getUsers.
     * @return A collection of values returned by getUsers.
     */
    public suspend fun getUsers(argument: GetUsersPlainArgs): GetUsersResult =
        getUsersResultToKotlin(getUsersPlain(argument.toJava()).await())

    /**
     * @see [getUsers].
     * @param nameRegex Regex string to apply to the IAM users list returned by AWS. This allows more advanced filtering not supported from the AWS API. This filtering is done locally on what AWS returns, and could have a performance impact if the result is large. Combine this with other options to narrow down the list AWS returns.
     * @param pathPrefix Path prefix for filtering the results. For example, the prefix `/division_abc/subdivision_xyz/` gets all users whose path starts with `/division_abc/subdivision_xyz/`. If it is not included, it defaults to a slash (`/`), listing all users. For more details, check out [list-users in the AWS CLI reference][1].
     * @return A collection of values returned by getUsers.
     */
    public suspend fun getUsers(nameRegex: String? = null, pathPrefix: String? = null):
        GetUsersResult {
        val argument = GetUsersPlainArgs(
            nameRegex = nameRegex,
            pathPrefix = pathPrefix,
        )
        return getUsersResultToKotlin(getUsersPlain(argument.toJava()).await())
    }

    /**
     * @see [getUsers].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;iam&#46;kotlin&#46;inputs&#46;GetUsersPlainArgs].
     * @return A collection of values returned by getUsers.
     */
    public suspend fun getUsers(argument: suspend GetUsersPlainArgsBuilder.() -> Unit):
        GetUsersResult {
        val builder = GetUsersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUsersResultToKotlin(getUsersPlain(builtArgument.toJava()).await())
    }
}
