@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [PolicyAttachment].
 */
@PulumiTagMarker
public class PolicyAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolicyAttachmentArgs = PolicyAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PolicyAttachmentArgsBuilder.() -> Unit) {
        val builder = PolicyAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PolicyAttachment {
        val builtJavaResource = com.pulumi.aws.iam.PolicyAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PolicyAttachment(builtJavaResource)
    }
}

/**
 * Attaches a Managed IAM Policy to user(s), role(s), and/or group(s)
 * !> **WARNING:** The aws.iam.PolicyAttachment resource creates **exclusive** attachments of IAM policies. Across the entire AWS account, all of the users/roles/groups to which a single policy is attached must be declared by a single aws.iam.PolicyAttachment resource. This means that even any users/roles/groups that have the attached policy via any other mechanism (including other resources managed by this provider) will have that attached policy revoked by this resource. Consider `aws.iam.RolePolicyAttachment`, `aws.iam.UserPolicyAttachment`, or `aws.iam.GroupPolicyAttachment` instead. These resources do not enforce exclusive attachment of an IAM policy.
 * > **NOTE:** The usage of this resource conflicts with the `aws.iam.GroupPolicyAttachment`, `aws.iam.RolePolicyAttachment`, and `aws.iam.UserPolicyAttachment` resources and will permanently show a difference if both are defined.
 * > **NOTE:** For a given role, this resource is incompatible with using the `aws.iam.Role` resource `managed_policy_arns` argument. When using that argument and this resource, both will attempt to manage the role's managed policy attachments and the provider will show a permanent difference.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.User;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.Group;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import com.pulumi.aws.iam.PolicyAttachment;
 * import com.pulumi.aws.iam.PolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var user = new User("user");
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("ec2.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var role = new Role("role", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var group = new Group("group");
 *         final var policyPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("ec2:Describe*")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var policyPolicy = new Policy("policyPolicy", PolicyArgs.builder()
 *             .description("A test policy")
 *             .policy(policyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var test_attach = new PolicyAttachment("test-attach", PolicyAttachmentArgs.builder()
 *             .users(user.name())
 *             .roles(role.name())
 *             .groups(group.name())
 *             .policyArn(policyPolicy.arn())
 *             .build());
 *     }
 * }
 * ```
 */
public class PolicyAttachment internal constructor(
    override val javaResource: com.pulumi.aws.iam.PolicyAttachment,
) : KotlinCustomResource(javaResource, PolicyAttachmentMapper) {
    /**
     * The group(s) the policy should be applied to
     */
    public val groups: Output<List<String>>?
        get() = javaResource.groups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The name of the attachment. This cannot be an empty string.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The ARN of the policy you want to apply
     */
    public val policyArn: Output<String>
        get() = javaResource.policyArn().applyValue({ args0 -> args0 })

    /**
     * The role(s) the policy should be applied to
     */
    public val roles: Output<List<String>>?
        get() = javaResource.roles().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The user(s) the policy should be applied to
     */
    public val users: Output<List<String>>?
        get() = javaResource.users().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object PolicyAttachmentMapper : ResourceMapper<PolicyAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iam.PolicyAttachment::class == javaResource::class

    override fun map(javaResource: Resource): PolicyAttachment = PolicyAttachment(
        javaResource as
            com.pulumi.aws.iam.PolicyAttachment,
    )
}

/**
 * @see [PolicyAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PolicyAttachment].
 */
public suspend fun policyAttachment(
    name: String,
    block: suspend PolicyAttachmentResourceBuilder.() -> Unit,
): PolicyAttachment {
    val builder = PolicyAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PolicyAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun policyAttachment(name: String): PolicyAttachment {
    val builder = PolicyAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
