@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.aws.iam.PolicyAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Attaches a Managed IAM Policy to user(s), role(s), and/or group(s)
 * !> **WARNING:** The aws.iam.PolicyAttachment resource creates **exclusive** attachments of IAM policies. Across the entire AWS account, all of the users/roles/groups to which a single policy is attached must be declared by a single aws.iam.PolicyAttachment resource. This means that even any users/roles/groups that have the attached policy via any other mechanism (including other resources managed by this provider) will have that attached policy revoked by this resource. Consider `aws.iam.RolePolicyAttachment`, `aws.iam.UserPolicyAttachment`, or `aws.iam.GroupPolicyAttachment` instead. These resources do not enforce exclusive attachment of an IAM policy.
 * > **NOTE:** The usage of this resource conflicts with the `aws.iam.GroupPolicyAttachment`, `aws.iam.RolePolicyAttachment`, and `aws.iam.UserPolicyAttachment` resources and will permanently show a difference if both are defined.
 * > **NOTE:** For a given role, this resource is incompatible with using the `aws.iam.Role` resource `managed_policy_arns` argument. When using that argument and this resource, both will attempt to manage the role's managed policy attachments and the provider will show a permanent difference.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.User;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.Group;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import com.pulumi.aws.iam.PolicyAttachment;
 * import com.pulumi.aws.iam.PolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var user = new User("user");
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("ec2.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var role = new Role("role", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var group = new Group("group");
 *         final var policyPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("ec2:Describe*")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var policyPolicy = new Policy("policyPolicy", PolicyArgs.builder()
 *             .description("A test policy")
 *             .policy(policyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var test_attach = new PolicyAttachment("test-attach", PolicyAttachmentArgs.builder()
 *             .users(user.name())
 *             .roles(role.name())
 *             .groups(group.name())
 *             .policyArn(policyPolicy.arn())
 *             .build());
 *     }
 * }
 * ```
 * @property groups The group(s) the policy should be applied to
 * @property name The name of the attachment. This cannot be an empty string.
 * @property policyArn The ARN of the policy you want to apply
 * @property roles The role(s) the policy should be applied to
 * @property users The user(s) the policy should be applied to
 */
public data class PolicyAttachmentArgs(
    public val groups: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val policyArn: Output<String>? = null,
    public val roles: Output<List<String>>? = null,
    public val users: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.PolicyAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.iam.PolicyAttachmentArgs =
        com.pulumi.aws.iam.PolicyAttachmentArgs.builder()
            .groups(groups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .policyArn(policyArn?.applyValue({ args0 -> args0 }))
            .roles(roles?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .users(users?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [PolicyAttachmentArgs].
 */
@PulumiTagMarker
public class PolicyAttachmentArgsBuilder internal constructor() {
    private var groups: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var policyArn: Output<String>? = null

    private var roles: Output<List<String>>? = null

    private var users: Output<List<String>>? = null

    /**
     * @param value The group(s) the policy should be applied to
     */
    @JvmName("trpwrouwwqffwyau")
    public suspend fun groups(`value`: Output<List<String>>) {
        this.groups = value
    }

    @JvmName("vfxrcpeupbmxwnlb")
    public suspend fun groups(vararg values: Output<String>) {
        this.groups = Output.all(values.asList())
    }

    /**
     * @param values The group(s) the policy should be applied to
     */
    @JvmName("gwjggloxkrnhylpn")
    public suspend fun groups(values: List<Output<String>>) {
        this.groups = Output.all(values)
    }

    /**
     * @param value The name of the attachment. This cannot be an empty string.
     */
    @JvmName("unbipgbuqdgbwqhv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ARN of the policy you want to apply
     */
    @JvmName("mocnhlcnjniomqgc")
    public suspend fun policyArn(`value`: Output<String>) {
        this.policyArn = value
    }

    /**
     * @param value The role(s) the policy should be applied to
     */
    @JvmName("cmtruikivyqxwtvh")
    public suspend fun roles(`value`: Output<List<String>>) {
        this.roles = value
    }

    @JvmName("ssduntfygshuljdj")
    public suspend fun roles(vararg values: Output<String>) {
        this.roles = Output.all(values.asList())
    }

    /**
     * @param values The role(s) the policy should be applied to
     */
    @JvmName("swhuhbusicsmqoav")
    public suspend fun roles(values: List<Output<String>>) {
        this.roles = Output.all(values)
    }

    /**
     * @param value The user(s) the policy should be applied to
     */
    @JvmName("holxtfuvsyklftfd")
    public suspend fun users(`value`: Output<List<String>>) {
        this.users = value
    }

    @JvmName("siledfsoudskrmjm")
    public suspend fun users(vararg values: Output<String>) {
        this.users = Output.all(values.asList())
    }

    /**
     * @param values The user(s) the policy should be applied to
     */
    @JvmName("mqacdheibhvclwyy")
    public suspend fun users(values: List<Output<String>>) {
        this.users = Output.all(values)
    }

    /**
     * @param value The group(s) the policy should be applied to
     */
    @JvmName("fvxyeumbhwiscnlq")
    public suspend fun groups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groups = mapped
    }

    /**
     * @param values The group(s) the policy should be applied to
     */
    @JvmName("aaffspfwavlfmvkg")
    public suspend fun groups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groups = mapped
    }

    /**
     * @param value The name of the attachment. This cannot be an empty string.
     */
    @JvmName("psnjgiyapapmpsqh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The ARN of the policy you want to apply
     */
    @JvmName("jlfmheftnujnybyj")
    public suspend fun policyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyArn = mapped
    }

    /**
     * @param value The role(s) the policy should be applied to
     */
    @JvmName("qaxbxqnustwuqvmc")
    public suspend fun roles(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    /**
     * @param values The role(s) the policy should be applied to
     */
    @JvmName("sjhkubwwbnqhaqpk")
    public suspend fun roles(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    /**
     * @param value The user(s) the policy should be applied to
     */
    @JvmName("elpvbhloahswahpg")
    public suspend fun users(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.users = mapped
    }

    /**
     * @param values The user(s) the policy should be applied to
     */
    @JvmName("dgthjgdowygfdwko")
    public suspend fun users(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.users = mapped
    }

    internal fun build(): PolicyAttachmentArgs = PolicyAttachmentArgs(
        groups = groups,
        name = name,
        policyArn = policyArn,
        roles = roles,
        users = users,
    )
}
