@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.aws.iam.kotlin.outputs.RoleInlinePolicy
import com.pulumi.aws.iam.kotlin.outputs.RoleInlinePolicy.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Role].
 */
@PulumiTagMarker
public class RoleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RoleArgs = RoleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RoleArgsBuilder.() -> Unit) {
        val builder = RoleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Role {
        val builtJavaResource = com.pulumi.aws.iam.Role(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Role(builtJavaResource)
    }
}

/**
 * Provides an IAM role.
 * > **NOTE:** If policies are attached to the role via the `aws.iam.PolicyAttachment` resource and you are modifying the role `name` or `path`, the `force_detach_policies` argument must be set to `true` and applied before attempting the operation otherwise you will encounter a `DeleteConflict` error. The `aws.iam.RolePolicyAttachment` resource (recommended) does not have this requirement.
 * > **NOTE:** If you use this resource's `managed_policy_arns` argument or `inline_policy` configuration blocks, this resource will take over exclusive management of the role's respective policy types (e.g., both policy types if both arguments are used). These arguments are incompatible with other ways of managing a role's policies, such as `aws.iam.PolicyAttachment`, `aws.iam.RolePolicyAttachment`, and `aws.iam.RolePolicy`. If you attempt to manage a role's policies by multiple means, you will get resource cycling and/or errors.
 * ## Example Usage
 * ### Basic Example
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testRole = new Role("testRole", RoleArgs.builder()
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Sid", ""),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "ec2.amazonaws.com")
 *                         ))
 *                     )))
 *                 )))
 *             .tags(Map.of("tag-key", "tag-value"))
 *             .build());
 *     }
 * }
 * ```
 * ### Example of Using Data Source for Assume Role Policy
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var instanceAssumeRolePolicy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("ec2.amazonaws.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var instance = new Role("instance", RoleArgs.builder()
 *             .path("/system/")
 *             .assumeRolePolicy(instanceAssumeRolePolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *     }
 * }
 * ```
 * ### Example of Exclusive Inline Policies
 * This example creates an IAM role with two inline IAM policies. If someone adds another inline policy out-of-band, on the next apply, this provider will remove that policy. If someone deletes these policies out-of-band, this provider will recreate them.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.inputs.RoleInlinePolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var inlinePolicy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("ec2:DescribeAccountAttributes")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var example = new Role("example", RoleArgs.builder()
 *             .assumeRolePolicy(data.aws_iam_policy_document().instance_assume_role_policy().json())
 *             .inlinePolicies(
 *                 RoleInlinePolicyArgs.builder()
 *                     .name("my_inline_policy")
 *                     .policy(serializeJson(
 *                         jsonObject(
 *                             jsonProperty("Version", "2012-10-17"),
 *                             jsonProperty("Statement", jsonArray(jsonObject(
 *                                 jsonProperty("Action", jsonArray("ec2:Describe*")),
 *                                 jsonProperty("Effect", "Allow"),
 *                                 jsonProperty("Resource", "*")
 *                             )))
 *                         )))
 *                     .build(),
 *                 RoleInlinePolicyArgs.builder()
 *                     .name("policy-8675309")
 *                     .policy(inlinePolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Example of Removing Inline Policies
 * This example creates an IAM role with what appears to be empty IAM `inline_policy` argument instead of using `inline_policy` as a configuration block. The result is that if someone were to add an inline policy out-of-band, on the next apply, this provider will remove that policy.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.inputs.RoleInlinePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Role("example", RoleArgs.builder()
 *             .assumeRolePolicy(data.aws_iam_policy_document().instance_assume_role_policy().json())
 *             .inlinePolicies()
 *             .build());
 *     }
 * }
 * ```
 * ### Example of Exclusive Managed Policies
 * This example creates an IAM role and attaches two managed IAM policies. If someone attaches another managed policy out-of-band, on the next apply, this provider will detach that policy. If someone detaches these policies out-of-band, this provider will attach them again.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyOne = new Policy("policyOne", PolicyArgs.builder()
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", jsonArray("ec2:Describe*")),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Resource", "*")
 *                     )))
 *                 )))
 *             .build());
 *         var policyTwo = new Policy("policyTwo", PolicyArgs.builder()
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", jsonArray(
 *                             "s3:ListAllMyBuckets",
 *                             "s3:ListBucket",
 *                             "s3:HeadBucket"
 *                         )),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Resource", "*")
 *                     )))
 *                 )))
 *             .build());
 *         var example = new Role("example", RoleArgs.builder()
 *             .assumeRolePolicy(data.aws_iam_policy_document().instance_assume_role_policy().json())
 *             .managedPolicyArns(
 *                 policyOne.arn(),
 *                 policyTwo.arn())
 *             .build());
 *     }
 * }
 * ```
 * ### Example of Removing Managed Policies
 * This example creates an IAM role with an empty `managed_policy_arns` argument. If someone attaches a policy out-of-band, on the next apply, this provider will detach that policy.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Role("example", RoleArgs.builder()
 *             .assumeRolePolicy(data.aws_iam_policy_document().instance_assume_role_policy().json())
 *             .managedPolicyArns()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IAM Roles using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:iam/role:Role developer developer_name
 * ```
 *
 */
public class Role internal constructor(
    override val javaResource: com.pulumi.aws.iam.Role,
) : KotlinCustomResource(javaResource, RoleMapper) {
    /**
     * Amazon Resource Name (ARN) specifying the role.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Policy that grants an entity permission to assume the role.
     * > **NOTE:** The `assume_role_policy` is very similar to but slightly different than a standard IAM policy and cannot use an `aws.iam.Policy` resource.  However, it _can_ use an `aws.iam.getPolicyDocument` data source. See the example above of how this works.
     * The following arguments are optional:
     */
    public val assumeRolePolicy: Output<String>
        get() = javaResource.assumeRolePolicy().applyValue({ args0 -> args0 })

    /**
     * Creation date of the IAM role.
     */
    public val createDate: Output<String>
        get() = javaResource.createDate().applyValue({ args0 -> args0 })

    /**
     * Description of the role.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to force detaching any policies the role has before destroying it. Defaults to `false`.
     */
    public val forceDetachPolicies: Output<Boolean>?
        get() = javaResource.forceDetachPolicies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration block defining an exclusive set of IAM inline policies associated with the IAM role. See below. If no blocks are configured, the provider will not manage any inline policies in this resource. Configuring one empty block (i.e., `inline_policy {}`) will cause the provider to remove _all_ inline policies added out of band on `apply`.
     */
    public val inlinePolicies: Output<List<RoleInlinePolicy>>
        get() = javaResource.inlinePolicies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    public val managedPolicyArns: Output<List<String>>
        get() = javaResource.managedPolicyArns().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Maximum session duration (in seconds) that you want to set for the specified role. If you do not specify a value for this setting, the default maximum of one hour is applied. This setting can have a value from 1 hour to 12 hours.
     */
    public val maxSessionDuration: Output<Int>?
        get() = javaResource.maxSessionDuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Friendly name of the role. If omitted, the provider will assign a random, unique name. See [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) for more information.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique friendly name beginning with the specified prefix. Conflicts with `name`.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * Path to the role. See [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) for more information.
     */
    public val path: Output<String>?
        get() = javaResource.path().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * ARN of the policy that is used to set the permissions boundary for the role.
     */
    public val permissionsBoundary: Output<String>?
        get() = javaResource.permissionsBoundary().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Key-value mapping of tags for the IAM role. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Stable and unique string identifying the role.
     */
    public val uniqueId: Output<String>
        get() = javaResource.uniqueId().applyValue({ args0 -> args0 })
}

public object RoleMapper : ResourceMapper<Role> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iam.Role::class == javaResource::class

    override fun map(javaResource: Resource): Role = Role(javaResource as com.pulumi.aws.iam.Role)
}

/**
 * @see [Role].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Role].
 */
public suspend fun role(name: String, block: suspend RoleResourceBuilder.() -> Unit): Role {
    val builder = RoleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Role].
 * @param name The _unique_ name of the resulting resource.
 */
public fun role(name: String): Role {
    val builder = RoleResourceBuilder()
    builder.name(name)
    return builder.build()
}
