@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.aws.iam.RoleArgs.builder
import com.pulumi.aws.iam.kotlin.inputs.RoleInlinePolicyArgs
import com.pulumi.aws.iam.kotlin.inputs.RoleInlinePolicyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an IAM role.
 * > **NOTE:** If policies are attached to the role via the `aws.iam.PolicyAttachment` resource and you are modifying the role `name` or `path`, the `force_detach_policies` argument must be set to `true` and applied before attempting the operation otherwise you will encounter a `DeleteConflict` error. The `aws.iam.RolePolicyAttachment` resource (recommended) does not have this requirement.
 * > **NOTE:** If you use this resource's `managed_policy_arns` argument or `inline_policy` configuration blocks, this resource will take over exclusive management of the role's respective policy types (e.g., both policy types if both arguments are used). These arguments are incompatible with other ways of managing a role's policies, such as `aws.iam.PolicyAttachment`, `aws.iam.RolePolicyAttachment`, and `aws.iam.RolePolicy`. If you attempt to manage a role's policies by multiple means, you will get resource cycling and/or errors.
 * ## Example Usage
 * ### Basic Example
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testRole = new Role("testRole", RoleArgs.builder()
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Sid", ""),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "ec2.amazonaws.com")
 *                         ))
 *                     )))
 *                 )))
 *             .tags(Map.of("tag-key", "tag-value"))
 *             .build());
 *     }
 * }
 * ```
 * ### Example of Using Data Source for Assume Role Policy
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var instanceAssumeRolePolicy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("ec2.amazonaws.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var instance = new Role("instance", RoleArgs.builder()
 *             .path("/system/")
 *             .assumeRolePolicy(instanceAssumeRolePolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *     }
 * }
 * ```
 * ### Example of Exclusive Inline Policies
 * This example creates an IAM role with two inline IAM policies. If someone adds another inline policy out-of-band, on the next apply, this provider will remove that policy. If someone deletes these policies out-of-band, this provider will recreate them.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.inputs.RoleInlinePolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var inlinePolicy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("ec2:DescribeAccountAttributes")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var example = new Role("example", RoleArgs.builder()
 *             .assumeRolePolicy(data.aws_iam_policy_document().instance_assume_role_policy().json())
 *             .inlinePolicies(
 *                 RoleInlinePolicyArgs.builder()
 *                     .name("my_inline_policy")
 *                     .policy(serializeJson(
 *                         jsonObject(
 *                             jsonProperty("Version", "2012-10-17"),
 *                             jsonProperty("Statement", jsonArray(jsonObject(
 *                                 jsonProperty("Action", jsonArray("ec2:Describe*")),
 *                                 jsonProperty("Effect", "Allow"),
 *                                 jsonProperty("Resource", "*")
 *                             )))
 *                         )))
 *                     .build(),
 *                 RoleInlinePolicyArgs.builder()
 *                     .name("policy-8675309")
 *                     .policy(inlinePolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Example of Removing Inline Policies
 * This example creates an IAM role with what appears to be empty IAM `inline_policy` argument instead of using `inline_policy` as a configuration block. The result is that if someone were to add an inline policy out-of-band, on the next apply, this provider will remove that policy.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.inputs.RoleInlinePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Role("example", RoleArgs.builder()
 *             .assumeRolePolicy(data.aws_iam_policy_document().instance_assume_role_policy().json())
 *             .inlinePolicies()
 *             .build());
 *     }
 * }
 * ```
 * ### Example of Exclusive Managed Policies
 * This example creates an IAM role and attaches two managed IAM policies. If someone attaches another managed policy out-of-band, on the next apply, this provider will detach that policy. If someone detaches these policies out-of-band, this provider will attach them again.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyOne = new Policy("policyOne", PolicyArgs.builder()
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", jsonArray("ec2:Describe*")),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Resource", "*")
 *                     )))
 *                 )))
 *             .build());
 *         var policyTwo = new Policy("policyTwo", PolicyArgs.builder()
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", jsonArray(
 *                             "s3:ListAllMyBuckets",
 *                             "s3:ListBucket",
 *                             "s3:HeadBucket"
 *                         )),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Resource", "*")
 *                     )))
 *                 )))
 *             .build());
 *         var example = new Role("example", RoleArgs.builder()
 *             .assumeRolePolicy(data.aws_iam_policy_document().instance_assume_role_policy().json())
 *             .managedPolicyArns(
 *                 policyOne.arn(),
 *                 policyTwo.arn())
 *             .build());
 *     }
 * }
 * ```
 * ### Example of Removing Managed Policies
 * This example creates an IAM role with an empty `managed_policy_arns` argument. If someone attaches a policy out-of-band, on the next apply, this provider will detach that policy.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Role("example", RoleArgs.builder()
 *             .assumeRolePolicy(data.aws_iam_policy_document().instance_assume_role_policy().json())
 *             .managedPolicyArns()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IAM Roles using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:iam/role:Role developer developer_name
 * ```
 * @property assumeRolePolicy Policy that grants an entity permission to assume the role.
 * > **NOTE:** The `assume_role_policy` is very similar to but slightly different than a standard IAM policy and cannot use an `aws.iam.Policy` resource.  However, it _can_ use an `aws.iam.getPolicyDocument` data source. See the example above of how this works.
 * The following arguments are optional:
 * @property description Description of the role.
 * @property forceDetachPolicies Whether to force detaching any policies the role has before destroying it. Defaults to `false`.
 * @property inlinePolicies Configuration block defining an exclusive set of IAM inline policies associated with the IAM role. See below. If no blocks are configured, the provider will not manage any inline policies in this resource. Configuring one empty block (i.e., `inline_policy {}`) will cause the provider to remove _all_ inline policies added out of band on `apply`.
 * @property managedPolicyArns
 * @property maxSessionDuration Maximum session duration (in seconds) that you want to set for the specified role. If you do not specify a value for this setting, the default maximum of one hour is applied. This setting can have a value from 1 hour to 12 hours.
 * @property name Friendly name of the role. If omitted, the provider will assign a random, unique name. See [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) for more information.
 * @property namePrefix Creates a unique friendly name beginning with the specified prefix. Conflicts with `name`.
 * @property path Path to the role. See [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) for more information.
 * @property permissionsBoundary ARN of the policy that is used to set the permissions boundary for the role.
 * @property tags Key-value mapping of tags for the IAM role. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class RoleArgs(
    public val assumeRolePolicy: Output<String>? = null,
    public val description: Output<String>? = null,
    public val forceDetachPolicies: Output<Boolean>? = null,
    public val inlinePolicies: Output<List<RoleInlinePolicyArgs>>? = null,
    public val managedPolicyArns: Output<List<String>>? = null,
    public val maxSessionDuration: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val path: Output<String>? = null,
    public val permissionsBoundary: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.RoleArgs> {
    override fun toJava(): com.pulumi.aws.iam.RoleArgs = com.pulumi.aws.iam.RoleArgs.builder()
        .assumeRolePolicy(assumeRolePolicy?.applyValue({ args0 -> args0 }))
        .description(description?.applyValue({ args0 -> args0 }))
        .forceDetachPolicies(forceDetachPolicies?.applyValue({ args0 -> args0 }))
        .inlinePolicies(
            inlinePolicies?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .managedPolicyArns(managedPolicyArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .maxSessionDuration(maxSessionDuration?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
        .path(path?.applyValue({ args0 -> args0 }))
        .permissionsBoundary(permissionsBoundary?.applyValue({ args0 -> args0 }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [RoleArgs].
 */
@PulumiTagMarker
public class RoleArgsBuilder internal constructor() {
    private var assumeRolePolicy: Output<String>? = null

    private var description: Output<String>? = null

    private var forceDetachPolicies: Output<Boolean>? = null

    private var inlinePolicies: Output<List<RoleInlinePolicyArgs>>? = null

    private var managedPolicyArns: Output<List<String>>? = null

    private var maxSessionDuration: Output<Int>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var path: Output<String>? = null

    private var permissionsBoundary: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Policy that grants an entity permission to assume the role.
     * > **NOTE:** The `assume_role_policy` is very similar to but slightly different than a standard IAM policy and cannot use an `aws.iam.Policy` resource.  However, it _can_ use an `aws.iam.getPolicyDocument` data source. See the example above of how this works.
     * The following arguments are optional:
     */
    @JvmName("umrkkfoeyhxfoftw")
    public suspend fun assumeRolePolicy(`value`: Output<String>) {
        this.assumeRolePolicy = value
    }

    /**
     * @param value Description of the role.
     */
    @JvmName("gpcmibyexwkuikqy")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Whether to force detaching any policies the role has before destroying it. Defaults to `false`.
     */
    @JvmName("foqhqdfprupwbaju")
    public suspend fun forceDetachPolicies(`value`: Output<Boolean>) {
        this.forceDetachPolicies = value
    }

    /**
     * @param value Configuration block defining an exclusive set of IAM inline policies associated with the IAM role. See below. If no blocks are configured, the provider will not manage any inline policies in this resource. Configuring one empty block (i.e., `inline_policy {}`) will cause the provider to remove _all_ inline policies added out of band on `apply`.
     */
    @JvmName("koytdmrcebhkmost")
    public suspend fun inlinePolicies(`value`: Output<List<RoleInlinePolicyArgs>>) {
        this.inlinePolicies = value
    }

    @JvmName("vjphcwltciihabbx")
    public suspend fun inlinePolicies(vararg values: Output<RoleInlinePolicyArgs>) {
        this.inlinePolicies = Output.all(values.asList())
    }

    /**
     * @param values Configuration block defining an exclusive set of IAM inline policies associated with the IAM role. See below. If no blocks are configured, the provider will not manage any inline policies in this resource. Configuring one empty block (i.e., `inline_policy {}`) will cause the provider to remove _all_ inline policies added out of band on `apply`.
     */
    @JvmName("csemabrrfvdwvcro")
    public suspend fun inlinePolicies(values: List<Output<RoleInlinePolicyArgs>>) {
        this.inlinePolicies = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("bjhspvsnqcavffln")
    public suspend fun managedPolicyArns(`value`: Output<List<String>>) {
        this.managedPolicyArns = value
    }

    @JvmName("clfqvxiyarcwiyoc")
    public suspend fun managedPolicyArns(vararg values: Output<String>) {
        this.managedPolicyArns = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("kgygmaebbdrrnheo")
    public suspend fun managedPolicyArns(values: List<Output<String>>) {
        this.managedPolicyArns = Output.all(values)
    }

    /**
     * @param value Maximum session duration (in seconds) that you want to set for the specified role. If you do not specify a value for this setting, the default maximum of one hour is applied. This setting can have a value from 1 hour to 12 hours.
     */
    @JvmName("rnmoipjysrmylkia")
    public suspend fun maxSessionDuration(`value`: Output<Int>) {
        this.maxSessionDuration = value
    }

    /**
     * @param value Friendly name of the role. If omitted, the provider will assign a random, unique name. See [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) for more information.
     */
    @JvmName("imsjmbabkfcyntbk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique friendly name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("ogfnbhfestscoivd")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value Path to the role. See [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) for more information.
     */
    @JvmName("wwbihrhotlcbjqnp")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value ARN of the policy that is used to set the permissions boundary for the role.
     */
    @JvmName("ipsamkghgafuggml")
    public suspend fun permissionsBoundary(`value`: Output<String>) {
        this.permissionsBoundary = value
    }

    /**
     * @param value Key-value mapping of tags for the IAM role. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tvfkqvffkacqcqoh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Policy that grants an entity permission to assume the role.
     * > **NOTE:** The `assume_role_policy` is very similar to but slightly different than a standard IAM policy and cannot use an `aws.iam.Policy` resource.  However, it _can_ use an `aws.iam.getPolicyDocument` data source. See the example above of how this works.
     * The following arguments are optional:
     */
    @JvmName("viuxnpcokuienuit")
    public suspend fun assumeRolePolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assumeRolePolicy = mapped
    }

    /**
     * @param value Description of the role.
     */
    @JvmName("kwmtjhtgxaikhkxt")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Whether to force detaching any policies the role has before destroying it. Defaults to `false`.
     */
    @JvmName("nrtalpxynotxnwcn")
    public suspend fun forceDetachPolicies(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceDetachPolicies = mapped
    }

    /**
     * @param value Configuration block defining an exclusive set of IAM inline policies associated with the IAM role. See below. If no blocks are configured, the provider will not manage any inline policies in this resource. Configuring one empty block (i.e., `inline_policy {}`) will cause the provider to remove _all_ inline policies added out of band on `apply`.
     */
    @JvmName("sryprovefsyhmwra")
    public suspend fun inlinePolicies(`value`: List<RoleInlinePolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inlinePolicies = mapped
    }

    /**
     * @param argument Configuration block defining an exclusive set of IAM inline policies associated with the IAM role. See below. If no blocks are configured, the provider will not manage any inline policies in this resource. Configuring one empty block (i.e., `inline_policy {}`) will cause the provider to remove _all_ inline policies added out of band on `apply`.
     */
    @JvmName("mnauwmhuhesjcebq")
    public suspend
    fun inlinePolicies(argument: List<suspend RoleInlinePolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RoleInlinePolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inlinePolicies = mapped
    }

    /**
     * @param argument Configuration block defining an exclusive set of IAM inline policies associated with the IAM role. See below. If no blocks are configured, the provider will not manage any inline policies in this resource. Configuring one empty block (i.e., `inline_policy {}`) will cause the provider to remove _all_ inline policies added out of band on `apply`.
     */
    @JvmName("pyxlyhumbbjfnseg")
    public suspend fun inlinePolicies(
        vararg
        argument: suspend RoleInlinePolicyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RoleInlinePolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inlinePolicies = mapped
    }

    /**
     * @param argument Configuration block defining an exclusive set of IAM inline policies associated with the IAM role. See below. If no blocks are configured, the provider will not manage any inline policies in this resource. Configuring one empty block (i.e., `inline_policy {}`) will cause the provider to remove _all_ inline policies added out of band on `apply`.
     */
    @JvmName("jqutydfsswuqkaru")
    public suspend fun inlinePolicies(argument: suspend RoleInlinePolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RoleInlinePolicyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.inlinePolicies = mapped
    }

    /**
     * @param values Configuration block defining an exclusive set of IAM inline policies associated with the IAM role. See below. If no blocks are configured, the provider will not manage any inline policies in this resource. Configuring one empty block (i.e., `inline_policy {}`) will cause the provider to remove _all_ inline policies added out of band on `apply`.
     */
    @JvmName("bqqmuhsvsftfrujk")
    public suspend fun inlinePolicies(vararg values: RoleInlinePolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inlinePolicies = mapped
    }

    /**
     * @param value
     */
    @JvmName("oqciaahalqxhkeuq")
    public suspend fun managedPolicyArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedPolicyArns = mapped
    }

    /**
     * @param values
     */
    @JvmName("ovbawfynxdgbeiqs")
    public suspend fun managedPolicyArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managedPolicyArns = mapped
    }

    /**
     * @param value Maximum session duration (in seconds) that you want to set for the specified role. If you do not specify a value for this setting, the default maximum of one hour is applied. This setting can have a value from 1 hour to 12 hours.
     */
    @JvmName("gbegfqukmxxrqwyg")
    public suspend fun maxSessionDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxSessionDuration = mapped
    }

    /**
     * @param value Friendly name of the role. If omitted, the provider will assign a random, unique name. See [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) for more information.
     */
    @JvmName("khldcktaeunxqrjy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique friendly name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("dcuhkiwxeobylern")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value Path to the role. See [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) for more information.
     */
    @JvmName("jxvijgrwvtaxegml")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value ARN of the policy that is used to set the permissions boundary for the role.
     */
    @JvmName("qwiiqjegnssawfvx")
    public suspend fun permissionsBoundary(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissionsBoundary = mapped
    }

    /**
     * @param value Key-value mapping of tags for the IAM role. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sxbnrafdobnxnyop")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of tags for the IAM role. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("akvpeaksokmrufqa")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RoleArgs = RoleArgs(
        assumeRolePolicy = assumeRolePolicy,
        description = description,
        forceDetachPolicies = forceDetachPolicies,
        inlinePolicies = inlinePolicies,
        managedPolicyArns = managedPolicyArns,
        maxSessionDuration = maxSessionDuration,
        name = name,
        namePrefix = namePrefix,
        path = path,
        permissionsBoundary = permissionsBoundary,
        tags = tags,
    )
}
