@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RolePolicy].
 */
@PulumiTagMarker
public class RolePolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RolePolicyArgs = RolePolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RolePolicyArgsBuilder.() -> Unit) {
        val builder = RolePolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RolePolicy {
        val builtJavaResource = com.pulumi.aws.iam.RolePolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RolePolicy(builtJavaResource)
    }
}

/**
 * Provides an IAM role inline policy.
 * > **NOTE:** For a given role, this resource is incompatible with using the `aws.iam.Role` resource `inline_policy` argument. When using that argument and this resource, both will attempt to manage the role's inline policies and the provider will show a permanent difference.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testRole = new Role("testRole", RoleArgs.builder()
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Sid", ""),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "ec2.amazonaws.com")
 *                         ))
 *                     )))
 *                 )))
 *             .build());
 *         var testPolicy = new RolePolicy("testPolicy", RolePolicyArgs.builder()
 *             .role(testRole.id())
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", jsonArray("ec2:Describe*")),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Resource", "*")
 *                     )))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IAM Role Policies using the `role_name:role_policy_name`. For example:
 * ```sh
 *  $ pulumi import aws:iam/rolePolicy:RolePolicy mypolicy role_of_mypolicy_name:mypolicy_name
 * ```
 *
 */
public class RolePolicy internal constructor(
    override val javaResource: com.pulumi.aws.iam.RolePolicy,
) : KotlinCustomResource(javaResource, RolePolicyMapper) {
    /**
     * The name of the role policy. If omitted, this provider will
     * assign a random, unique name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique name beginning with the specified
     * prefix. Conflicts with `name`.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * The inline policy document. This is a JSON formatted string. For more information about building IAM policy documents with the provider, see the AWS IAM Policy Document Guide
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * The name of the IAM role to attach to the policy.
     */
    public val role: Output<String>
        get() = javaResource.role().applyValue({ args0 -> args0 })
}

public object RolePolicyMapper : ResourceMapper<RolePolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iam.RolePolicy::class == javaResource::class

    override fun map(javaResource: Resource): RolePolicy = RolePolicy(
        javaResource as
            com.pulumi.aws.iam.RolePolicy,
    )
}

/**
 * @see [RolePolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RolePolicy].
 */
public suspend fun rolePolicy(name: String, block: suspend RolePolicyResourceBuilder.() -> Unit):
    RolePolicy {
    val builder = RolePolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RolePolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun rolePolicy(name: String): RolePolicy {
    val builder = RolePolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
