@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RolePolicyAttachment].
 */
@PulumiTagMarker
public class RolePolicyAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RolePolicyAttachmentArgs = RolePolicyAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RolePolicyAttachmentArgsBuilder.() -> Unit) {
        val builder = RolePolicyAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RolePolicyAttachment {
        val builtJavaResource = com.pulumi.aws.iam.RolePolicyAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RolePolicyAttachment(builtJavaResource)
    }
}

/**
 * Attaches a Managed IAM Policy to an IAM role
 * > **NOTE:** The usage of this resource conflicts with the `aws.iam.PolicyAttachment` resource and will permanently show a difference if both are defined.
 * > **NOTE:** For a given role, this resource is incompatible with using the `aws.iam.Role` resource `managed_policy_arns` argument. When using that argument and this resource, both will attempt to manage the role's managed policy attachments and Pulumi will show a permanent difference.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("ec2.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var role = new Role("role", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var policyPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("ec2:Describe*")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var policyPolicy = new Policy("policyPolicy", PolicyArgs.builder()
 *             .description("A test policy")
 *             .policy(policyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var test_attach = new RolePolicyAttachment("test-attach", RolePolicyAttachmentArgs.builder()
 *             .role(role.name())
 *             .policyArn(policyPolicy.arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IAM role policy attachments using the role name and policy arn separated by `/`. For example:
 * ```sh
 *  $ pulumi import aws:iam/rolePolicyAttachment:RolePolicyAttachment test-attach test-role/arn:aws:iam::xxxxxxxxxxxx:policy/test-policy
 * ```
 *
 */
public class RolePolicyAttachment internal constructor(
    override val javaResource: com.pulumi.aws.iam.RolePolicyAttachment,
) : KotlinCustomResource(javaResource, RolePolicyAttachmentMapper) {
    /**
     * The ARN of the policy you want to apply
     */
    public val policyArn: Output<String>
        get() = javaResource.policyArn().applyValue({ args0 -> args0 })

    /**
     * The name of the IAM role to which the policy should be applied
     */
    public val role: Output<String>
        get() = javaResource.role().applyValue({ args0 -> args0 })
}

public object RolePolicyAttachmentMapper : ResourceMapper<RolePolicyAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iam.RolePolicyAttachment::class == javaResource::class

    override fun map(javaResource: Resource): RolePolicyAttachment = RolePolicyAttachment(
        javaResource
            as com.pulumi.aws.iam.RolePolicyAttachment,
    )
}

/**
 * @see [RolePolicyAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RolePolicyAttachment].
 */
public suspend fun rolePolicyAttachment(
    name: String,
    block: suspend RolePolicyAttachmentResourceBuilder.() -> Unit,
): RolePolicyAttachment {
    val builder = RolePolicyAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RolePolicyAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun rolePolicyAttachment(name: String): RolePolicyAttachment {
    val builder = RolePolicyAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
