@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.aws.iam.RolePolicyAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Attaches a Managed IAM Policy to an IAM role
 * > **NOTE:** The usage of this resource conflicts with the `aws.iam.PolicyAttachment` resource and will permanently show a difference if both are defined.
 * > **NOTE:** For a given role, this resource is incompatible with using the `aws.iam.Role` resource `managed_policy_arns` argument. When using that argument and this resource, both will attempt to manage the role's managed policy attachments and Pulumi will show a permanent difference.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("ec2.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var role = new Role("role", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var policyPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("ec2:Describe*")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var policyPolicy = new Policy("policyPolicy", PolicyArgs.builder()
 *             .description("A test policy")
 *             .policy(policyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var test_attach = new RolePolicyAttachment("test-attach", RolePolicyAttachmentArgs.builder()
 *             .role(role.name())
 *             .policyArn(policyPolicy.arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IAM role policy attachments using the role name and policy arn separated by `/`. For example:
 * ```sh
 *  $ pulumi import aws:iam/rolePolicyAttachment:RolePolicyAttachment test-attach test-role/arn:aws:iam::xxxxxxxxxxxx:policy/test-policy
 * ```
 * @property policyArn The ARN of the policy you want to apply
 * @property role The name of the IAM role to which the policy should be applied
 */
public data class RolePolicyAttachmentArgs(
    public val policyArn: Output<String>? = null,
    public val role: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.RolePolicyAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.iam.RolePolicyAttachmentArgs =
        com.pulumi.aws.iam.RolePolicyAttachmentArgs.builder()
            .policyArn(policyArn?.applyValue({ args0 -> args0 }))
            .role(role?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RolePolicyAttachmentArgs].
 */
@PulumiTagMarker
public class RolePolicyAttachmentArgsBuilder internal constructor() {
    private var policyArn: Output<String>? = null

    private var role: Output<String>? = null

    /**
     * @param value The ARN of the policy you want to apply
     */
    @JvmName("csvfncgchlkxmceo")
    public suspend fun policyArn(`value`: Output<String>) {
        this.policyArn = value
    }

    /**
     * @param value The name of the IAM role to which the policy should be applied
     */
    @JvmName("hbcwvaokdycuvcue")
    public suspend fun role(`value`: Output<String>) {
        this.role = value
    }

    /**
     * @param value The ARN of the policy you want to apply
     */
    @JvmName("ulhiesywvycyritu")
    public suspend fun policyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyArn = mapped
    }

    /**
     * @param value The name of the IAM role to which the policy should be applied
     */
    @JvmName("wvddtxihowraxera")
    public suspend fun role(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.role = mapped
    }

    internal fun build(): RolePolicyAttachmentArgs = RolePolicyAttachmentArgs(
        policyArn = policyArn,
        role = role,
    )
}
