@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.aws.iam.SamlProviderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an IAM SAML provider.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.SamlProvider;
 * import com.pulumi.aws.iam.SamlProviderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new SamlProvider("default", SamlProviderArgs.builder()
 *             .samlMetadataDocument(Files.readString(Paths.get("saml-metadata.xml")))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IAM SAML Providers using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:iam/samlProvider:SamlProvider default arn:aws:iam::123456789012:saml-provider/SAMLADFS
 * ```
 * @property name The name of the provider to create.
 * @property samlMetadataDocument An XML document generated by an identity provider that supports SAML 2.0.
 * @property tags Map of resource tags for the IAM SAML provider. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class SamlProviderArgs(
    public val name: Output<String>? = null,
    public val samlMetadataDocument: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.SamlProviderArgs> {
    override fun toJava(): com.pulumi.aws.iam.SamlProviderArgs =
        com.pulumi.aws.iam.SamlProviderArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .samlMetadataDocument(samlMetadataDocument?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SamlProviderArgs].
 */
@PulumiTagMarker
public class SamlProviderArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var samlMetadataDocument: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the provider to create.
     */
    @JvmName("ffddsfltkityakvr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value An XML document generated by an identity provider that supports SAML 2.0.
     */
    @JvmName("mhlxnkudpknphihr")
    public suspend fun samlMetadataDocument(`value`: Output<String>) {
        this.samlMetadataDocument = value
    }

    /**
     * @param value Map of resource tags for the IAM SAML provider. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("opetkxdfsydjibmk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the provider to create.
     */
    @JvmName("daykyaupbuudjtwp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value An XML document generated by an identity provider that supports SAML 2.0.
     */
    @JvmName("ungqthlmmdhlfsbt")
    public suspend fun samlMetadataDocument(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.samlMetadataDocument = mapped
    }

    /**
     * @param value Map of resource tags for the IAM SAML provider. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("awfxhaoqxymrhgdm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of resource tags for the IAM SAML provider. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qjkxmkejgaivrlpo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SamlProviderArgs = SamlProviderArgs(
        name = name,
        samlMetadataDocument = samlMetadataDocument,
        tags = tags,
    )
}
