@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.aws.iam.SecurityTokenServicePreferencesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an IAM Security Token Service Preferences resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.SecurityTokenServicePreferences;
 * import com.pulumi.aws.iam.SecurityTokenServicePreferencesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SecurityTokenServicePreferences("example", SecurityTokenServicePreferencesArgs.builder()
 *             .globalEndpointTokenVersion("v2Token")
 *             .build());
 *     }
 * }
 * ```
 * @property globalEndpointTokenVersion The version of the STS global endpoint token. Valid values: `v1Token`, `v2Token`.
 */
public data class SecurityTokenServicePreferencesArgs(
    public val globalEndpointTokenVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.SecurityTokenServicePreferencesArgs> {
    override fun toJava(): com.pulumi.aws.iam.SecurityTokenServicePreferencesArgs =
        com.pulumi.aws.iam.SecurityTokenServicePreferencesArgs.builder()
            .globalEndpointTokenVersion(globalEndpointTokenVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecurityTokenServicePreferencesArgs].
 */
@PulumiTagMarker
public class SecurityTokenServicePreferencesArgsBuilder internal constructor() {
    private var globalEndpointTokenVersion: Output<String>? = null

    /**
     * @param value The version of the STS global endpoint token. Valid values: `v1Token`, `v2Token`.
     */
    @JvmName("grkqwatqnxghsmsl")
    public suspend fun globalEndpointTokenVersion(`value`: Output<String>) {
        this.globalEndpointTokenVersion = value
    }

    /**
     * @param value The version of the STS global endpoint token. Valid values: `v1Token`, `v2Token`.
     */
    @JvmName("ybqddjbfnveouyfv")
    public suspend fun globalEndpointTokenVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalEndpointTokenVersion = mapped
    }

    internal fun build(): SecurityTokenServicePreferencesArgs = SecurityTokenServicePreferencesArgs(
        globalEndpointTokenVersion = globalEndpointTokenVersion,
    )
}
