@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ServerCertificate].
 */
@PulumiTagMarker
public class ServerCertificateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServerCertificateArgs = ServerCertificateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServerCertificateArgsBuilder.() -> Unit) {
        val builder = ServerCertificateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ServerCertificate {
        val builtJavaResource = com.pulumi.aws.iam.ServerCertificate(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ServerCertificate(builtJavaResource)
    }
}

/**
 * Provides an IAM Server Certificate resource to upload Server Certificates.
 * Certs uploaded to IAM can easily work with other AWS services such as:
 * - AWS Elastic Beanstalk
 * - Elastic Load Balancing
 * - CloudFront
 * - AWS OpsWorks
 * For information about server certificates in IAM, see [Managing Server
 * Certificates][2] in AWS Documentation.
 * ## Example Usage
 * **Using certs on file:**
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.ServerCertificate;
 * import com.pulumi.aws.iam.ServerCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testCert = new ServerCertificate("testCert", ServerCertificateArgs.builder()
 *             .certificateBody(Files.readString(Paths.get("self-ca-cert.pem")))
 *             .privateKey(Files.readString(Paths.get("test-key.pem")))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IAM Server Certificates using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:iam/serverCertificate:ServerCertificate certificate example.com-certificate-until-2018
 * ```
 *
 */
public class ServerCertificate internal constructor(
    override val javaResource: com.pulumi.aws.iam.ServerCertificate,
) : KotlinCustomResource(javaResource, ServerCertificateMapper) {
    /**
     * The Amazon Resource Name (ARN) specifying the server certificate.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The contents of the public key certificate in
     * PEM-encoded format.
     */
    public val certificateBody: Output<String>
        get() = javaResource.certificateBody().applyValue({ args0 -> args0 })

    /**
     * The contents of the certificate chain.
     * This is typically a concatenation of the PEM-encoded public key certificates
     * of the chain.
     */
    public val certificateChain: Output<String>?
        get() = javaResource.certificateChain().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) on which the certificate is set to expire.
     */
    public val expiration: Output<String>
        get() = javaResource.expiration().applyValue({ args0 -> args0 })

    /**
     * The name of the Server Certificate. Do not include the
     * path in this value. If omitted, the provider will assign a random, unique name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique name beginning with the specified
     * prefix. Conflicts with `name`.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * The IAM path for the server certificate.  If it is not
     * included, it defaults to a slash (/). If this certificate is for use with
     * AWS CloudFront, the path must be in format `/cloudfront/your_path_here`.
     * See [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) for more details on IAM Paths.
     */
    public val path: Output<String>?
        get() = javaResource.path().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The contents of the private key in PEM-encoded format.
     */
    public val privateKey: Output<String>
        get() = javaResource.privateKey().applyValue({ args0 -> args0 })

    /**
     * Map of resource tags for the server certificate. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * > **NOTE:** AWS performs behind-the-scenes modifications to some certificate files if they do not adhere to a specific format. These modifications will result in this provider forever believing that it needs to update the resources since the local and AWS file contents will not match after theses modifications occur. In order to prevent this from happening you must ensure that all your PEM-encoded files use UNIX line-breaks and that `certificate_body` contains only one certificate. All other certificates should go in `certificate_chain`. It is common for some Certificate Authorities to issue certificate files that have DOS line-breaks and that are actually multiple certificates concatenated together in order to form a full certificate chain.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) when the server certificate was uploaded.
     */
    public val uploadDate: Output<String>
        get() = javaResource.uploadDate().applyValue({ args0 -> args0 })
}

public object ServerCertificateMapper : ResourceMapper<ServerCertificate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iam.ServerCertificate::class == javaResource::class

    override fun map(javaResource: Resource): ServerCertificate = ServerCertificate(
        javaResource as
            com.pulumi.aws.iam.ServerCertificate,
    )
}

/**
 * @see [ServerCertificate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServerCertificate].
 */
public suspend fun serverCertificate(
    name: String,
    block: suspend ServerCertificateResourceBuilder.() -> Unit,
): ServerCertificate {
    val builder = ServerCertificateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServerCertificate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serverCertificate(name: String): ServerCertificate {
    val builder = ServerCertificateResourceBuilder()
    builder.name(name)
    return builder.build()
}
