@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ServiceLinkedRole].
 */
@PulumiTagMarker
public class ServiceLinkedRoleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceLinkedRoleArgs = ServiceLinkedRoleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceLinkedRoleArgsBuilder.() -> Unit) {
        val builder = ServiceLinkedRoleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ServiceLinkedRole {
        val builtJavaResource = com.pulumi.aws.iam.ServiceLinkedRole(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ServiceLinkedRole(builtJavaResource)
    }
}

/**
 * Provides an [IAM service-linked role](https://docs.aws.amazon.com/IAM/latest/UserGuide/using-service-linked-roles.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.ServiceLinkedRole;
 * import com.pulumi.aws.iam.ServiceLinkedRoleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var elasticbeanstalk = new ServiceLinkedRole("elasticbeanstalk", ServiceLinkedRoleArgs.builder()
 *             .awsServiceName("elasticbeanstalk.amazonaws.com")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IAM service-linked roles using role ARN. For example:
 * ```sh
 *  $ pulumi import aws:iam/serviceLinkedRole:ServiceLinkedRole elasticbeanstalk arn:aws:iam::123456789012:role/aws-service-role/elasticbeanstalk.amazonaws.com/AWSServiceRoleForElasticBeanstalk
 * ```
 *
 */
public class ServiceLinkedRole internal constructor(
    override val javaResource: com.pulumi.aws.iam.ServiceLinkedRole,
) : KotlinCustomResource(javaResource, ServiceLinkedRoleMapper) {
    /**
     * The Amazon Resource Name (ARN) specifying the role.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The AWS service to which this role is attached. You use a string similar to a URL but without the `http://` in front. For example: `elasticbeanstalk.amazonaws.com`. To find the full list of services that support service-linked roles, check [the docs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-services-that-work-with-iam.html).
     */
    public val awsServiceName: Output<String>
        get() = javaResource.awsServiceName().applyValue({ args0 -> args0 })

    /**
     * The creation date of the IAM role.
     */
    public val createDate: Output<String>
        get() = javaResource.createDate().applyValue({ args0 -> args0 })

    /**
     * Additional string appended to the role name. Not all AWS services support custom suffixes.
     */
    public val customSuffix: Output<String>?
        get() = javaResource.customSuffix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description of the role.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the role.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The path of the role.
     */
    public val path: Output<String>
        get() = javaResource.path().applyValue({ args0 -> args0 })

    /**
     * Key-value mapping of tags for the IAM role. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The stable and unique string identifying the role.
     */
    public val uniqueId: Output<String>
        get() = javaResource.uniqueId().applyValue({ args0 -> args0 })
}

public object ServiceLinkedRoleMapper : ResourceMapper<ServiceLinkedRole> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iam.ServiceLinkedRole::class == javaResource::class

    override fun map(javaResource: Resource): ServiceLinkedRole = ServiceLinkedRole(
        javaResource as
            com.pulumi.aws.iam.ServiceLinkedRole,
    )
}

/**
 * @see [ServiceLinkedRole].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServiceLinkedRole].
 */
public suspend fun serviceLinkedRole(
    name: String,
    block: suspend ServiceLinkedRoleResourceBuilder.() -> Unit,
): ServiceLinkedRole {
    val builder = ServiceLinkedRoleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServiceLinkedRole].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serviceLinkedRole(name: String): ServiceLinkedRole {
    val builder = ServiceLinkedRoleResourceBuilder()
    builder.name(name)
    return builder.build()
}
