@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ServiceSpecificCredential].
 */
@PulumiTagMarker
public class ServiceSpecificCredentialResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceSpecificCredentialArgs = ServiceSpecificCredentialArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceSpecificCredentialArgsBuilder.() -> Unit) {
        val builder = ServiceSpecificCredentialArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ServiceSpecificCredential {
        val builtJavaResource = com.pulumi.aws.iam.ServiceSpecificCredential(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ServiceSpecificCredential(builtJavaResource)
    }
}

/**
 * Provides an IAM Service Specific Credential.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.User;
 * import com.pulumi.aws.iam.ServiceSpecificCredential;
 * import com.pulumi.aws.iam.ServiceSpecificCredentialArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleUser = new User("exampleUser");
 *         var exampleServiceSpecificCredential = new ServiceSpecificCredential("exampleServiceSpecificCredential", ServiceSpecificCredentialArgs.builder()
 *             .serviceName("codecommit.amazonaws.com")
 *             .userName(exampleUser.name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IAM Service Specific Credentials using the `service_name:user_name:service_specific_credential_id`. For example:
 * ```sh
 *  $ pulumi import aws:iam/serviceSpecificCredential:ServiceSpecificCredential default `codecommit.amazonaws.com:example:some-id`
 * ```
 *
 */
public class ServiceSpecificCredential internal constructor(
    override val javaResource: com.pulumi.aws.iam.ServiceSpecificCredential,
) : KotlinCustomResource(javaResource, ServiceSpecificCredentialMapper) {
    /**
     * The name of the AWS service that is to be associated with the credentials. The service you specify here is the only service that can be accessed using these credentials.
     */
    public val serviceName: Output<String>
        get() = javaResource.serviceName().applyValue({ args0 -> args0 })

    /**
     * The generated password for the service-specific credential.
     */
    public val servicePassword: Output<String>
        get() = javaResource.servicePassword().applyValue({ args0 -> args0 })

    /**
     * The unique identifier for the service-specific credential.
     */
    public val serviceSpecificCredentialId: Output<String>
        get() = javaResource.serviceSpecificCredentialId().applyValue({ args0 -> args0 })

    /**
     * The generated user name for the service-specific credential. This value is generated by combining the IAM user's name combined with the ID number of the AWS account, as in `jane-at-123456789012`, for example.
     */
    public val serviceUserName: Output<String>
        get() = javaResource.serviceUserName().applyValue({ args0 -> args0 })

    /**
     * The status to be assigned to the service-specific credential. Valid values are `Active` and `Inactive`. Default value is `Active`.
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the IAM user that is to be associated with the credentials. The new service-specific credentials have the same permissions as the associated user except that they can be used only to access the specified service.
     */
    public val userName: Output<String>
        get() = javaResource.userName().applyValue({ args0 -> args0 })
}

public object ServiceSpecificCredentialMapper : ResourceMapper<ServiceSpecificCredential> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iam.ServiceSpecificCredential::class == javaResource::class

    override fun map(javaResource: Resource): ServiceSpecificCredential =
        ServiceSpecificCredential(javaResource as com.pulumi.aws.iam.ServiceSpecificCredential)
}

/**
 * @see [ServiceSpecificCredential].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServiceSpecificCredential].
 */
public suspend fun serviceSpecificCredential(
    name: String,
    block: suspend ServiceSpecificCredentialResourceBuilder.() -> Unit,
): ServiceSpecificCredential {
    val builder = ServiceSpecificCredentialResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServiceSpecificCredential].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serviceSpecificCredential(name: String): ServiceSpecificCredential {
    val builder = ServiceSpecificCredentialResourceBuilder()
    builder.name(name)
    return builder.build()
}
