@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.aws.iam.ServiceSpecificCredentialArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an IAM Service Specific Credential.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.User;
 * import com.pulumi.aws.iam.ServiceSpecificCredential;
 * import com.pulumi.aws.iam.ServiceSpecificCredentialArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleUser = new User("exampleUser");
 *         var exampleServiceSpecificCredential = new ServiceSpecificCredential("exampleServiceSpecificCredential", ServiceSpecificCredentialArgs.builder()
 *             .serviceName("codecommit.amazonaws.com")
 *             .userName(exampleUser.name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IAM Service Specific Credentials using the `service_name:user_name:service_specific_credential_id`. For example:
 * ```sh
 *  $ pulumi import aws:iam/serviceSpecificCredential:ServiceSpecificCredential default `codecommit.amazonaws.com:example:some-id`
 * ```
 * @property serviceName The name of the AWS service that is to be associated with the credentials. The service you specify here is the only service that can be accessed using these credentials.
 * @property status The status to be assigned to the service-specific credential. Valid values are `Active` and `Inactive`. Default value is `Active`.
 * @property userName The name of the IAM user that is to be associated with the credentials. The new service-specific credentials have the same permissions as the associated user except that they can be used only to access the specified service.
 */
public data class ServiceSpecificCredentialArgs(
    public val serviceName: Output<String>? = null,
    public val status: Output<String>? = null,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.ServiceSpecificCredentialArgs> {
    override fun toJava(): com.pulumi.aws.iam.ServiceSpecificCredentialArgs =
        com.pulumi.aws.iam.ServiceSpecificCredentialArgs.builder()
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceSpecificCredentialArgs].
 */
@PulumiTagMarker
public class ServiceSpecificCredentialArgsBuilder internal constructor() {
    private var serviceName: Output<String>? = null

    private var status: Output<String>? = null

    private var userName: Output<String>? = null

    /**
     * @param value The name of the AWS service that is to be associated with the credentials. The service you specify here is the only service that can be accessed using these credentials.
     */
    @JvmName("fosgnqkhdovpcjwr")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The status to be assigned to the service-specific credential. Valid values are `Active` and `Inactive`. Default value is `Active`.
     */
    @JvmName("smypcaxyctetvabn")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The name of the IAM user that is to be associated with the credentials. The new service-specific credentials have the same permissions as the associated user except that they can be used only to access the specified service.
     */
    @JvmName("fpwpkujyqxckckag")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value The name of the AWS service that is to be associated with the credentials. The service you specify here is the only service that can be accessed using these credentials.
     */
    @JvmName("yyuhottwtfbaqkcg")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value The status to be assigned to the service-specific credential. Valid values are `Active` and `Inactive`. Default value is `Active`.
     */
    @JvmName("skwmskempptqqwvy")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The name of the IAM user that is to be associated with the credentials. The new service-specific credentials have the same permissions as the associated user except that they can be used only to access the specified service.
     */
    @JvmName("msnllxxtpreqaqil")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): ServiceSpecificCredentialArgs = ServiceSpecificCredentialArgs(
        serviceName = serviceName,
        status = status,
        userName = userName,
    )
}
