@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SigningCertificate].
 */
@PulumiTagMarker
public class SigningCertificateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SigningCertificateArgs = SigningCertificateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SigningCertificateArgsBuilder.() -> Unit) {
        val builder = SigningCertificateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SigningCertificate {
        val builtJavaResource = com.pulumi.aws.iam.SigningCertificate(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SigningCertificate(builtJavaResource)
    }
}

/**
 * Provides an IAM Signing Certificate resource to upload Signing Certificates.
 * > **Note:** All arguments including the certificate body will be stored in the raw state as plain-text.
 * ## Example Usage
 * **Using certs on file:**
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.SigningCertificate;
 * import com.pulumi.aws.iam.SigningCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testCert = new SigningCertificate("testCert", SigningCertificateArgs.builder()
 *             .username("some_test_cert")
 *             .certificateBody(Files.readString(Paths.get("self-ca-cert.pem")))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IAM Signing Certificates using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:iam/signingCertificate:SigningCertificate certificate IDIDIDIDID:user-name
 * ```
 *
 */
public class SigningCertificate internal constructor(
    override val javaResource: com.pulumi.aws.iam.SigningCertificate,
) : KotlinCustomResource(javaResource, SigningCertificateMapper) {
    /**
     * The contents of the signing certificate in PEM-encoded format.
     */
    public val certificateBody: Output<String>
        get() = javaResource.certificateBody().applyValue({ args0 -> args0 })

    /**
     * The ID for the signing certificate.
     */
    public val certificateId: Output<String>
        get() = javaResource.certificateId().applyValue({ args0 -> args0 })

    /**
     * The status you want to assign to the certificate. `Active` means that the certificate can be used for programmatic calls to Amazon Web Services `Inactive` means that the certificate cannot be used.
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the user the signing certificate is for.
     */
    public val userName: Output<String>
        get() = javaResource.userName().applyValue({ args0 -> args0 })
}

public object SigningCertificateMapper : ResourceMapper<SigningCertificate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iam.SigningCertificate::class == javaResource::class

    override fun map(javaResource: Resource): SigningCertificate = SigningCertificate(
        javaResource as
            com.pulumi.aws.iam.SigningCertificate,
    )
}

/**
 * @see [SigningCertificate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SigningCertificate].
 */
public suspend fun signingCertificate(
    name: String,
    block: suspend SigningCertificateResourceBuilder.() -> Unit,
): SigningCertificate {
    val builder = SigningCertificateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SigningCertificate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun signingCertificate(name: String): SigningCertificate {
    val builder = SigningCertificateResourceBuilder()
    builder.name(name)
    return builder.build()
}
