@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.aws.iam.SigningCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an IAM Signing Certificate resource to upload Signing Certificates.
 * > **Note:** All arguments including the certificate body will be stored in the raw state as plain-text.
 * ## Example Usage
 * **Using certs on file:**
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.SigningCertificate;
 * import com.pulumi.aws.iam.SigningCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testCert = new SigningCertificate("testCert", SigningCertificateArgs.builder()
 *             .username("some_test_cert")
 *             .certificateBody(Files.readString(Paths.get("self-ca-cert.pem")))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IAM Signing Certificates using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:iam/signingCertificate:SigningCertificate certificate IDIDIDIDID:user-name
 * ```
 * @property certificateBody The contents of the signing certificate in PEM-encoded format.
 * @property status The status you want to assign to the certificate. `Active` means that the certificate can be used for programmatic calls to Amazon Web Services `Inactive` means that the certificate cannot be used.
 * @property userName The name of the user the signing certificate is for.
 */
public data class SigningCertificateArgs(
    public val certificateBody: Output<String>? = null,
    public val status: Output<String>? = null,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.SigningCertificateArgs> {
    override fun toJava(): com.pulumi.aws.iam.SigningCertificateArgs =
        com.pulumi.aws.iam.SigningCertificateArgs.builder()
            .certificateBody(certificateBody?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SigningCertificateArgs].
 */
@PulumiTagMarker
public class SigningCertificateArgsBuilder internal constructor() {
    private var certificateBody: Output<String>? = null

    private var status: Output<String>? = null

    private var userName: Output<String>? = null

    /**
     * @param value The contents of the signing certificate in PEM-encoded format.
     */
    @JvmName("dpvtaaqmwaondsll")
    public suspend fun certificateBody(`value`: Output<String>) {
        this.certificateBody = value
    }

    /**
     * @param value The status you want to assign to the certificate. `Active` means that the certificate can be used for programmatic calls to Amazon Web Services `Inactive` means that the certificate cannot be used.
     */
    @JvmName("spdflctyuqbaapyf")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The name of the user the signing certificate is for.
     */
    @JvmName("xdmpmoajyvsbyjmo")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value The contents of the signing certificate in PEM-encoded format.
     */
    @JvmName("gxcupnlbyvvmebtk")
    public suspend fun certificateBody(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateBody = mapped
    }

    /**
     * @param value The status you want to assign to the certificate. `Active` means that the certificate can be used for programmatic calls to Amazon Web Services `Inactive` means that the certificate cannot be used.
     */
    @JvmName("djdevnxjrygkrtpg")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The name of the user the signing certificate is for.
     */
    @JvmName("sfefhapbitejbodw")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): SigningCertificateArgs = SigningCertificateArgs(
        certificateBody = certificateBody,
        status = status,
        userName = userName,
    )
}
