@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.aws.iam.SshKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Uploads an SSH public key and associates it with the specified IAM user.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.User;
 * import com.pulumi.aws.iam.UserArgs;
 * import com.pulumi.aws.iam.SshKey;
 * import com.pulumi.aws.iam.SshKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var userUser = new User("userUser", UserArgs.builder()
 *             .path("/")
 *             .build());
 *         var userSshKey = new SshKey("userSshKey", SshKeyArgs.builder()
 *             .username(userUser.name())
 *             .encoding("SSH")
 *             .publicKey("ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQD3F6tyPEFEzV0LX3X8BsXdMsQz1x2cEikKDEY0aIj41qgxMCP/iteneqXSIFZBp5vizPvaoIR3Um9xK7PGoW8giupGn+EPuxIA4cDM4vzOqOkiMPhz5XK0whEjkVzTo4+S0puvDZuwIsdiW9mxhJc7tgBNL0cYlWSYVkz4G/fslNfRPW5mYAM49f4fhtxPb5ok4Q2Lg9dPKVHO/Bgeu5woMc7RY0p1ej6D4CKFE6lymSDJpW0YHX/wqE9+cfEauh7xZcG0q9t2ta6F6fmX0agvpFyZo8aFbXeUBr7osSCJNgvavWbM/06niWrOvYX2xwWdhXmXSrbX8ZbabVohBK41 mytest@mydomain.com")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SSH public keys using the `username`, `ssh_public_key_id`, and `encoding`. For example:
 * ```sh
 *  $ pulumi import aws:iam/sshKey:SshKey user user:APKAJNCNNJICVN7CFKCA:SSH
 * ```
 * @property encoding Specifies the public key encoding format to use in the response. To retrieve the public key in ssh-rsa format, use `SSH`. To retrieve the public key in PEM format, use `PEM`.
 * @property publicKey The SSH public key. The public key must be encoded in ssh-rsa format or PEM format.
 * @property status The status to assign to the SSH public key. Active means the key can be used for authentication with an AWS CodeCommit repository. Inactive means the key cannot be used. Default is `active`.
 * @property username The name of the IAM user to associate the SSH public key with.
 */
public data class SshKeyArgs(
    public val encoding: Output<String>? = null,
    public val publicKey: Output<String>? = null,
    public val status: Output<String>? = null,
    public val username: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.SshKeyArgs> {
    override fun toJava(): com.pulumi.aws.iam.SshKeyArgs = com.pulumi.aws.iam.SshKeyArgs.builder()
        .encoding(encoding?.applyValue({ args0 -> args0 }))
        .publicKey(publicKey?.applyValue({ args0 -> args0 }))
        .status(status?.applyValue({ args0 -> args0 }))
        .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SshKeyArgs].
 */
@PulumiTagMarker
public class SshKeyArgsBuilder internal constructor() {
    private var encoding: Output<String>? = null

    private var publicKey: Output<String>? = null

    private var status: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value Specifies the public key encoding format to use in the response. To retrieve the public key in ssh-rsa format, use `SSH`. To retrieve the public key in PEM format, use `PEM`.
     */
    @JvmName("eljgghmnftyjnbaa")
    public suspend fun encoding(`value`: Output<String>) {
        this.encoding = value
    }

    /**
     * @param value The SSH public key. The public key must be encoded in ssh-rsa format or PEM format.
     */
    @JvmName("govqpdjfeyujurpo")
    public suspend fun publicKey(`value`: Output<String>) {
        this.publicKey = value
    }

    /**
     * @param value The status to assign to the SSH public key. Active means the key can be used for authentication with an AWS CodeCommit repository. Inactive means the key cannot be used. Default is `active`.
     */
    @JvmName("apugnsyolsiuwgup")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The name of the IAM user to associate the SSH public key with.
     */
    @JvmName("aeidxwkngnsblmwd")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value Specifies the public key encoding format to use in the response. To retrieve the public key in ssh-rsa format, use `SSH`. To retrieve the public key in PEM format, use `PEM`.
     */
    @JvmName("aqfsopqybyjfwuve")
    public suspend fun encoding(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encoding = mapped
    }

    /**
     * @param value The SSH public key. The public key must be encoded in ssh-rsa format or PEM format.
     */
    @JvmName("esknntefhnaimmuu")
    public suspend fun publicKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicKey = mapped
    }

    /**
     * @param value The status to assign to the SSH public key. Active means the key can be used for authentication with an AWS CodeCommit repository. Inactive means the key cannot be used. Default is `active`.
     */
    @JvmName("ffdeuivqcbfgnhoa")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The name of the IAM user to associate the SSH public key with.
     */
    @JvmName("svyonbuyhueojdmw")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): SshKeyArgs = SshKeyArgs(
        encoding = encoding,
        publicKey = publicKey,
        status = status,
        username = username,
    )
}
