@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [UserGroupMembership].
 */
@PulumiTagMarker
public class UserGroupMembershipResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserGroupMembershipArgs = UserGroupMembershipArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserGroupMembershipArgsBuilder.() -> Unit) {
        val builder = UserGroupMembershipArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): UserGroupMembership {
        val builtJavaResource = com.pulumi.aws.iam.UserGroupMembership(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UserGroupMembership(builtJavaResource)
    }
}

/**
 * Provides a resource for adding an IAM User to IAM Groups. This
 * resource can be used multiple times with the same user for non-overlapping
 * groups.
 * To exclusively manage the users in a group, see the
 * `aws.iam.GroupMembership` resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.User;
 * import com.pulumi.aws.iam.Group;
 * import com.pulumi.aws.iam.UserGroupMembership;
 * import com.pulumi.aws.iam.UserGroupMembershipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var user1 = new User("user1");
 *         var group1 = new Group("group1");
 *         var group2 = new Group("group2");
 *         var example1 = new UserGroupMembership("example1", UserGroupMembershipArgs.builder()
 *             .user(user1.name())
 *             .groups(
 *                 group1.name(),
 *                 group2.name())
 *             .build());
 *         var group3 = new Group("group3");
 *         var example2 = new UserGroupMembership("example2", UserGroupMembershipArgs.builder()
 *             .user(user1.name())
 *             .groups(group3.name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IAM user group membership using the user name and group names separated by `/`. For example:
 * ```sh
 *  $ pulumi import aws:iam/userGroupMembership:UserGroupMembership example1 user1/group1/group2
 * ```
 *
 */
public class UserGroupMembership internal constructor(
    override val javaResource: com.pulumi.aws.iam.UserGroupMembership,
) : KotlinCustomResource(javaResource, UserGroupMembershipMapper) {
    /**
     * A list of IAM Groups to add the user to
     */
    public val groups: Output<List<String>>
        get() = javaResource.groups().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The name of the IAM User to add to groups
     */
    public val user: Output<String>
        get() = javaResource.user().applyValue({ args0 -> args0 })
}

public object UserGroupMembershipMapper : ResourceMapper<UserGroupMembership> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iam.UserGroupMembership::class == javaResource::class

    override fun map(javaResource: Resource): UserGroupMembership = UserGroupMembership(
        javaResource
            as com.pulumi.aws.iam.UserGroupMembership,
    )
}

/**
 * @see [UserGroupMembership].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UserGroupMembership].
 */
public suspend fun userGroupMembership(
    name: String,
    block: suspend UserGroupMembershipResourceBuilder.() -> Unit,
): UserGroupMembership {
    val builder = UserGroupMembershipResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UserGroupMembership].
 * @param name The _unique_ name of the resulting resource.
 */
public fun userGroupMembership(name: String): UserGroupMembership {
    val builder = UserGroupMembershipResourceBuilder()
    builder.name(name)
    return builder.build()
}
