@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.aws.iam.UserGroupMembershipArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a resource for adding an IAM User to IAM Groups. This
 * resource can be used multiple times with the same user for non-overlapping
 * groups.
 * To exclusively manage the users in a group, see the
 * `aws.iam.GroupMembership` resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.User;
 * import com.pulumi.aws.iam.Group;
 * import com.pulumi.aws.iam.UserGroupMembership;
 * import com.pulumi.aws.iam.UserGroupMembershipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var user1 = new User("user1");
 *         var group1 = new Group("group1");
 *         var group2 = new Group("group2");
 *         var example1 = new UserGroupMembership("example1", UserGroupMembershipArgs.builder()
 *             .user(user1.name())
 *             .groups(
 *                 group1.name(),
 *                 group2.name())
 *             .build());
 *         var group3 = new Group("group3");
 *         var example2 = new UserGroupMembership("example2", UserGroupMembershipArgs.builder()
 *             .user(user1.name())
 *             .groups(group3.name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IAM user group membership using the user name and group names separated by `/`. For example:
 * ```sh
 *  $ pulumi import aws:iam/userGroupMembership:UserGroupMembership example1 user1/group1/group2
 * ```
 * @property groups A list of IAM Groups to add the user to
 * @property user The name of the IAM User to add to groups
 */
public data class UserGroupMembershipArgs(
    public val groups: Output<List<String>>? = null,
    public val user: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.UserGroupMembershipArgs> {
    override fun toJava(): com.pulumi.aws.iam.UserGroupMembershipArgs =
        com.pulumi.aws.iam.UserGroupMembershipArgs.builder()
            .groups(groups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .user(user?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserGroupMembershipArgs].
 */
@PulumiTagMarker
public class UserGroupMembershipArgsBuilder internal constructor() {
    private var groups: Output<List<String>>? = null

    private var user: Output<String>? = null

    /**
     * @param value A list of IAM Groups to add the user to
     */
    @JvmName("clacuerpdwalhttx")
    public suspend fun groups(`value`: Output<List<String>>) {
        this.groups = value
    }

    @JvmName("cdwywpjtgsssoroi")
    public suspend fun groups(vararg values: Output<String>) {
        this.groups = Output.all(values.asList())
    }

    /**
     * @param values A list of IAM Groups to add the user to
     */
    @JvmName("pyjqhckdxktunxxm")
    public suspend fun groups(values: List<Output<String>>) {
        this.groups = Output.all(values)
    }

    /**
     * @param value The name of the IAM User to add to groups
     */
    @JvmName("fmusqvjepuwljrvp")
    public suspend fun user(`value`: Output<String>) {
        this.user = value
    }

    /**
     * @param value A list of IAM Groups to add the user to
     */
    @JvmName("atpchipuclahjbgy")
    public suspend fun groups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groups = mapped
    }

    /**
     * @param values A list of IAM Groups to add the user to
     */
    @JvmName("vracbydwwumxmcwu")
    public suspend fun groups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groups = mapped
    }

    /**
     * @param value The name of the IAM User to add to groups
     */
    @JvmName("xmpaobihliglyogf")
    public suspend fun user(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.user = mapped
    }

    internal fun build(): UserGroupMembershipArgs = UserGroupMembershipArgs(
        groups = groups,
        user = user,
    )
}
