@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [UserLoginProfile].
 */
@PulumiTagMarker
public class UserLoginProfileResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserLoginProfileArgs = UserLoginProfileArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserLoginProfileArgsBuilder.() -> Unit) {
        val builder = UserLoginProfileArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): UserLoginProfile {
        val builtJavaResource = com.pulumi.aws.iam.UserLoginProfile(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UserLoginProfile(builtJavaResource)
    }
}

/**
 * Manages an IAM User Login Profile with limited support for password creation during this provider resource creation. Uses PGP to encrypt the password for safe transport to the user. PGP keys can be obtained from Keybase.
 * > To reset an IAM User login password via this provider, you can use delete and recreate this resource or change any of the arguments.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.User;
 * import com.pulumi.aws.iam.UserArgs;
 * import com.pulumi.aws.iam.UserLoginProfile;
 * import com.pulumi.aws.iam.UserLoginProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleUser = new User("exampleUser", UserArgs.builder()
 *             .path("/")
 *             .forceDestroy(true)
 *             .build());
 *         var exampleUserLoginProfile = new UserLoginProfile("exampleUserLoginProfile", UserLoginProfileArgs.builder()
 *             .user(exampleUser.name())
 *             .pgpKey("keybase:some_person_that_exists")
 *             .build());
 *         ctx.export("password", exampleUserLoginProfile.encryptedPassword());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IAM User Login Profiles without password information via the IAM User name. For example:
 * ```sh
 *  $ pulumi import aws:iam/userLoginProfile:UserLoginProfile example myusername
 * ```
 *  Since Pulumi has no method to read the PGP or password information during import, use the resource options `ignore_changes` argument to ignore them (unless you want to recreate a password). For example:
 */
public class UserLoginProfile internal constructor(
    override val javaResource: com.pulumi.aws.iam.UserLoginProfile,
) : KotlinCustomResource(javaResource, UserLoginProfileMapper) {
    /**
     * The encrypted password, base64 encoded. Only available if password was handled on resource creation, not import.
     */
    public val encryptedPassword: Output<String>
        get() = javaResource.encryptedPassword().applyValue({ args0 -> args0 })

    /**
     * The fingerprint of the PGP key used to encrypt the password. Only available if password was handled on this provider resource creation, not import.
     */
    public val keyFingerprint: Output<String>
        get() = javaResource.keyFingerprint().applyValue({ args0 -> args0 })

    /**
     * The plain text password, only available when `pgp_key` is not provided.
     */
    public val password: Output<String>
        get() = javaResource.password().applyValue({ args0 -> args0 })

    /**
     * The length of the generated password on resource creation. Only applies on resource creation. Drift detection is not possible with this argument. Default value is `20`.
     */
    public val passwordLength: Output<Int>?
        get() = javaResource.passwordLength().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether the user should be forced to reset the generated password on resource creation. Only applies on resource creation.
     */
    public val passwordResetRequired: Output<Boolean>
        get() = javaResource.passwordResetRequired().applyValue({ args0 -> args0 })

    /**
     * Either a base-64 encoded PGP public key, or a keybase username in the form `keybase:username`. Only applies on resource creation. Drift detection is not possible with this argument.
     */
    public val pgpKey: Output<String>?
        get() = javaResource.pgpKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The IAM user's name.
     */
    public val user: Output<String>
        get() = javaResource.user().applyValue({ args0 -> args0 })
}

public object UserLoginProfileMapper : ResourceMapper<UserLoginProfile> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iam.UserLoginProfile::class == javaResource::class

    override fun map(javaResource: Resource): UserLoginProfile = UserLoginProfile(
        javaResource as
            com.pulumi.aws.iam.UserLoginProfile,
    )
}

/**
 * @see [UserLoginProfile].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UserLoginProfile].
 */
public suspend fun userLoginProfile(
    name: String,
    block: suspend UserLoginProfileResourceBuilder.() -> Unit,
): UserLoginProfile {
    val builder = UserLoginProfileResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UserLoginProfile].
 * @param name The _unique_ name of the resulting resource.
 */
public fun userLoginProfile(name: String): UserLoginProfile {
    val builder = UserLoginProfileResourceBuilder()
    builder.name(name)
    return builder.build()
}
