@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.aws.iam.UserLoginProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages an IAM User Login Profile with limited support for password creation during this provider resource creation. Uses PGP to encrypt the password for safe transport to the user. PGP keys can be obtained from Keybase.
 * > To reset an IAM User login password via this provider, you can use delete and recreate this resource or change any of the arguments.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.User;
 * import com.pulumi.aws.iam.UserArgs;
 * import com.pulumi.aws.iam.UserLoginProfile;
 * import com.pulumi.aws.iam.UserLoginProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleUser = new User("exampleUser", UserArgs.builder()
 *             .path("/")
 *             .forceDestroy(true)
 *             .build());
 *         var exampleUserLoginProfile = new UserLoginProfile("exampleUserLoginProfile", UserLoginProfileArgs.builder()
 *             .user(exampleUser.name())
 *             .pgpKey("keybase:some_person_that_exists")
 *             .build());
 *         ctx.export("password", exampleUserLoginProfile.encryptedPassword());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IAM User Login Profiles without password information via the IAM User name. For example:
 * ```sh
 *  $ pulumi import aws:iam/userLoginProfile:UserLoginProfile example myusername
 * ```
 *  Since Pulumi has no method to read the PGP or password information during import, use the resource options `ignore_changes` argument to ignore them (unless you want to recreate a password). For example:
 * @property passwordLength The length of the generated password on resource creation. Only applies on resource creation. Drift detection is not possible with this argument. Default value is `20`.
 * @property passwordResetRequired Whether the user should be forced to reset the generated password on resource creation. Only applies on resource creation.
 * @property pgpKey Either a base-64 encoded PGP public key, or a keybase username in the form `keybase:username`. Only applies on resource creation. Drift detection is not possible with this argument.
 * @property user The IAM user's name.
 */
public data class UserLoginProfileArgs(
    public val passwordLength: Output<Int>? = null,
    public val passwordResetRequired: Output<Boolean>? = null,
    public val pgpKey: Output<String>? = null,
    public val user: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.UserLoginProfileArgs> {
    override fun toJava(): com.pulumi.aws.iam.UserLoginProfileArgs =
        com.pulumi.aws.iam.UserLoginProfileArgs.builder()
            .passwordLength(passwordLength?.applyValue({ args0 -> args0 }))
            .passwordResetRequired(passwordResetRequired?.applyValue({ args0 -> args0 }))
            .pgpKey(pgpKey?.applyValue({ args0 -> args0 }))
            .user(user?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserLoginProfileArgs].
 */
@PulumiTagMarker
public class UserLoginProfileArgsBuilder internal constructor() {
    private var passwordLength: Output<Int>? = null

    private var passwordResetRequired: Output<Boolean>? = null

    private var pgpKey: Output<String>? = null

    private var user: Output<String>? = null

    /**
     * @param value The length of the generated password on resource creation. Only applies on resource creation. Drift detection is not possible with this argument. Default value is `20`.
     */
    @JvmName("jikgbljajrltliab")
    public suspend fun passwordLength(`value`: Output<Int>) {
        this.passwordLength = value
    }

    /**
     * @param value Whether the user should be forced to reset the generated password on resource creation. Only applies on resource creation.
     */
    @JvmName("efdysenyxaprcgri")
    public suspend fun passwordResetRequired(`value`: Output<Boolean>) {
        this.passwordResetRequired = value
    }

    /**
     * @param value Either a base-64 encoded PGP public key, or a keybase username in the form `keybase:username`. Only applies on resource creation. Drift detection is not possible with this argument.
     */
    @JvmName("ebvfpkwitysbdjqk")
    public suspend fun pgpKey(`value`: Output<String>) {
        this.pgpKey = value
    }

    /**
     * @param value The IAM user's name.
     */
    @JvmName("drwnaysgxkfxyyvo")
    public suspend fun user(`value`: Output<String>) {
        this.user = value
    }

    /**
     * @param value The length of the generated password on resource creation. Only applies on resource creation. Drift detection is not possible with this argument. Default value is `20`.
     */
    @JvmName("lidaweuqyxnemfjh")
    public suspend fun passwordLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordLength = mapped
    }

    /**
     * @param value Whether the user should be forced to reset the generated password on resource creation. Only applies on resource creation.
     */
    @JvmName("vhjdyynkigcnxrmp")
    public suspend fun passwordResetRequired(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordResetRequired = mapped
    }

    /**
     * @param value Either a base-64 encoded PGP public key, or a keybase username in the form `keybase:username`. Only applies on resource creation. Drift detection is not possible with this argument.
     */
    @JvmName("rikgyjidxnnhkfbw")
    public suspend fun pgpKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pgpKey = mapped
    }

    /**
     * @param value The IAM user's name.
     */
    @JvmName("mkckasavcrblujmw")
    public suspend fun user(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.user = mapped
    }

    internal fun build(): UserLoginProfileArgs = UserLoginProfileArgs(
        passwordLength = passwordLength,
        passwordResetRequired = passwordResetRequired,
        pgpKey = pgpKey,
        user = user,
    )
}
