@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [UserPolicy].
 */
@PulumiTagMarker
public class UserPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserPolicyArgs = UserPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserPolicyArgsBuilder.() -> Unit) {
        val builder = UserPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): UserPolicy {
        val builtJavaResource = com.pulumi.aws.iam.UserPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UserPolicy(builtJavaResource)
    }
}

/**
 * Provides an IAM policy attached to a user.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.User;
 * import com.pulumi.aws.iam.UserArgs;
 * import com.pulumi.aws.iam.UserPolicy;
 * import com.pulumi.aws.iam.UserPolicyArgs;
 * import com.pulumi.aws.iam.AccessKey;
 * import com.pulumi.aws.iam.AccessKeyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lbUser = new User("lbUser", UserArgs.builder()
 *             .path("/system/")
 *             .build());
 *         var lbRo = new UserPolicy("lbRo", UserPolicyArgs.builder()
 *             .user(lbUser.name())
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", jsonArray("ec2:Describe*")),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Resource", "*")
 *                     )))
 *                 )))
 *             .build());
 *         var lbAccessKey = new AccessKey("lbAccessKey", AccessKeyArgs.builder()
 *             .user(lbUser.name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IAM User Policies using the `user_name:user_policy_name`. For example:
 * ```sh
 *  $ pulumi import aws:iam/userPolicy:UserPolicy mypolicy user_of_mypolicy_name:mypolicy_name
 * ```
 *
 */
public class UserPolicy internal constructor(
    override val javaResource: com.pulumi.aws.iam.UserPolicy,
) : KotlinCustomResource(javaResource, UserPolicyMapper) {
    /**
     * The name of the policy. If omitted, the provider will assign a random, unique name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * The policy document. This is a JSON formatted string.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * IAM user to which to attach this policy.
     */
    public val user: Output<String>
        get() = javaResource.user().applyValue({ args0 -> args0 })
}

public object UserPolicyMapper : ResourceMapper<UserPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iam.UserPolicy::class == javaResource::class

    override fun map(javaResource: Resource): UserPolicy = UserPolicy(
        javaResource as
            com.pulumi.aws.iam.UserPolicy,
    )
}

/**
 * @see [UserPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UserPolicy].
 */
public suspend fun userPolicy(name: String, block: suspend UserPolicyResourceBuilder.() -> Unit):
    UserPolicy {
    val builder = UserPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UserPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun userPolicy(name: String): UserPolicy {
    val builder = UserPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
