@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.aws.iam.UserPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an IAM policy attached to a user.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.User;
 * import com.pulumi.aws.iam.UserArgs;
 * import com.pulumi.aws.iam.UserPolicy;
 * import com.pulumi.aws.iam.UserPolicyArgs;
 * import com.pulumi.aws.iam.AccessKey;
 * import com.pulumi.aws.iam.AccessKeyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lbUser = new User("lbUser", UserArgs.builder()
 *             .path("/system/")
 *             .build());
 *         var lbRo = new UserPolicy("lbRo", UserPolicyArgs.builder()
 *             .user(lbUser.name())
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", jsonArray("ec2:Describe*")),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Resource", "*")
 *                     )))
 *                 )))
 *             .build());
 *         var lbAccessKey = new AccessKey("lbAccessKey", AccessKeyArgs.builder()
 *             .user(lbUser.name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IAM User Policies using the `user_name:user_policy_name`. For example:
 * ```sh
 *  $ pulumi import aws:iam/userPolicy:UserPolicy mypolicy user_of_mypolicy_name:mypolicy_name
 * ```
 * @property name The name of the policy. If omitted, the provider will assign a random, unique name.
 * @property namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`.
 * @property policy The policy document. This is a JSON formatted string.
 * @property user IAM user to which to attach this policy.
 */
public data class UserPolicyArgs(
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val policy: Output<String>? = null,
    public val user: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.UserPolicyArgs> {
    override fun toJava(): com.pulumi.aws.iam.UserPolicyArgs =
        com.pulumi.aws.iam.UserPolicyArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 }))
            .user(user?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserPolicyArgs].
 */
@PulumiTagMarker
public class UserPolicyArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var policy: Output<String>? = null

    private var user: Output<String>? = null

    /**
     * @param value The name of the policy. If omitted, the provider will assign a random, unique name.
     */
    @JvmName("suqqnnuctkwtnpdn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("cuxmghyomvvfmjjx")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value The policy document. This is a JSON formatted string.
     */
    @JvmName("kvxhijtmbmsuyjbe")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value IAM user to which to attach this policy.
     */
    @JvmName("nuwmbvflrajpalhv")
    public suspend fun user(`value`: Output<String>) {
        this.user = value
    }

    /**
     * @param value The name of the policy. If omitted, the provider will assign a random, unique name.
     */
    @JvmName("vekgrattslcolcyf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("idllfqecwpgkbebl")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value The policy document. This is a JSON formatted string.
     */
    @JvmName("clnpxrakxmlhwpsm")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value IAM user to which to attach this policy.
     */
    @JvmName("mectgmouswmeotan")
    public suspend fun user(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.user = mapped
    }

    internal fun build(): UserPolicyArgs = UserPolicyArgs(
        name = name,
        namePrefix = namePrefix,
        policy = policy,
        user = user,
    )
}
