@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [UserPolicyAttachment].
 */
@PulumiTagMarker
public class UserPolicyAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserPolicyAttachmentArgs = UserPolicyAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserPolicyAttachmentArgsBuilder.() -> Unit) {
        val builder = UserPolicyAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): UserPolicyAttachment {
        val builtJavaResource = com.pulumi.aws.iam.UserPolicyAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UserPolicyAttachment(builtJavaResource)
    }
}

/**
 * Attaches a Managed IAM Policy to an IAM user
 * > **NOTE:** The usage of this resource conflicts with the `aws.iam.PolicyAttachment` resource and will permanently show a difference if both are defined.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.User;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import com.pulumi.aws.iam.UserPolicyAttachment;
 * import com.pulumi.aws.iam.UserPolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var user = new User("user");
 *         var policy = new Policy("policy", PolicyArgs.builder()
 *             .description("A test policy")
 *             .policy("{ ... policy JSON ... }")
 *             .build());
 *         var test_attach = new UserPolicyAttachment("test-attach", UserPolicyAttachmentArgs.builder()
 *             .user(user.name())
 *             .policyArn(policy.arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IAM user policy attachments using the user name and policy arn separated by `/`. For example:
 * ```sh
 *  $ pulumi import aws:iam/userPolicyAttachment:UserPolicyAttachment test-attach test-user/arn:aws:iam::xxxxxxxxxxxx:policy/test-policy
 * ```
 *
 */
public class UserPolicyAttachment internal constructor(
    override val javaResource: com.pulumi.aws.iam.UserPolicyAttachment,
) : KotlinCustomResource(javaResource, UserPolicyAttachmentMapper) {
    /**
     * The ARN of the policy you want to apply
     */
    public val policyArn: Output<String>
        get() = javaResource.policyArn().applyValue({ args0 -> args0 })

    /**
     * The user the policy should be applied to
     */
    public val user: Output<String>
        get() = javaResource.user().applyValue({ args0 -> args0 })
}

public object UserPolicyAttachmentMapper : ResourceMapper<UserPolicyAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iam.UserPolicyAttachment::class == javaResource::class

    override fun map(javaResource: Resource): UserPolicyAttachment = UserPolicyAttachment(
        javaResource
            as com.pulumi.aws.iam.UserPolicyAttachment,
    )
}

/**
 * @see [UserPolicyAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UserPolicyAttachment].
 */
public suspend fun userPolicyAttachment(
    name: String,
    block: suspend UserPolicyAttachmentResourceBuilder.() -> Unit,
): UserPolicyAttachment {
    val builder = UserPolicyAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UserPolicyAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun userPolicyAttachment(name: String): UserPolicyAttachment {
    val builder = UserPolicyAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
