@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.aws.iam.UserPolicyAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Attaches a Managed IAM Policy to an IAM user
 * > **NOTE:** The usage of this resource conflicts with the `aws.iam.PolicyAttachment` resource and will permanently show a difference if both are defined.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.User;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import com.pulumi.aws.iam.UserPolicyAttachment;
 * import com.pulumi.aws.iam.UserPolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var user = new User("user");
 *         var policy = new Policy("policy", PolicyArgs.builder()
 *             .description("A test policy")
 *             .policy("{ ... policy JSON ... }")
 *             .build());
 *         var test_attach = new UserPolicyAttachment("test-attach", UserPolicyAttachmentArgs.builder()
 *             .user(user.name())
 *             .policyArn(policy.arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IAM user policy attachments using the user name and policy arn separated by `/`. For example:
 * ```sh
 *  $ pulumi import aws:iam/userPolicyAttachment:UserPolicyAttachment test-attach test-user/arn:aws:iam::xxxxxxxxxxxx:policy/test-policy
 * ```
 * @property policyArn The ARN of the policy you want to apply
 * @property user The user the policy should be applied to
 */
public data class UserPolicyAttachmentArgs(
    public val policyArn: Output<String>? = null,
    public val user: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.UserPolicyAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.iam.UserPolicyAttachmentArgs =
        com.pulumi.aws.iam.UserPolicyAttachmentArgs.builder()
            .policyArn(policyArn?.applyValue({ args0 -> args0 }))
            .user(user?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserPolicyAttachmentArgs].
 */
@PulumiTagMarker
public class UserPolicyAttachmentArgsBuilder internal constructor() {
    private var policyArn: Output<String>? = null

    private var user: Output<String>? = null

    /**
     * @param value The ARN of the policy you want to apply
     */
    @JvmName("lfuudgvbawpnhmlp")
    public suspend fun policyArn(`value`: Output<String>) {
        this.policyArn = value
    }

    /**
     * @param value The user the policy should be applied to
     */
    @JvmName("xvlthrqcukbcoujj")
    public suspend fun user(`value`: Output<String>) {
        this.user = value
    }

    /**
     * @param value The ARN of the policy you want to apply
     */
    @JvmName("stvtuagprkxxttta")
    public suspend fun policyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyArn = mapped
    }

    /**
     * @param value The user the policy should be applied to
     */
    @JvmName("cnxtaumjgoacgifg")
    public suspend fun user(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.user = mapped
    }

    internal fun build(): UserPolicyAttachmentArgs = UserPolicyAttachmentArgs(
        policyArn = policyArn,
        user = user,
    )
}
