@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [VirtualMfaDevice].
 */
@PulumiTagMarker
public class VirtualMfaDeviceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualMfaDeviceArgs = VirtualMfaDeviceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualMfaDeviceArgsBuilder.() -> Unit) {
        val builder = VirtualMfaDeviceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VirtualMfaDevice {
        val builtJavaResource = com.pulumi.aws.iam.VirtualMfaDevice(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VirtualMfaDevice(builtJavaResource)
    }
}

/**
 * Provides an IAM Virtual MFA Device.
 * > **Note:** All attributes will be stored in the raw state as plain-text.
 * > **Note:** A virtual MFA device cannot be directly associated with an IAM User from the provider.
 *   To associate the virtual MFA device with a user and enable it, use the code returned in either `base_32_string_seed` or `qr_code_png` to generate TOTP authentication codes.
 *   The authentication codes can then be used with the AWS CLI command [`aws iam enable-mfa-device`](https://docs&#46;aws&#46;amazon&#46;com/cli/latest/reference/iam/enable-mfa-device&#46;html) or the AWS API call [`EnableMFADevice`](https://docs.aws.amazon.com/IAM/latest/APIReference/API_EnableMFADevice.html).
 * ## Example Usage
 * **Using certs on file:**
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.VirtualMfaDevice;
 * import com.pulumi.aws.iam.VirtualMfaDeviceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VirtualMfaDevice("example", VirtualMfaDeviceArgs.builder()
 *             .virtualMfaDeviceName("example")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IAM Virtual MFA Devices using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:iam/virtualMfaDevice:VirtualMfaDevice example arn:aws:iam::123456789012:mfa/example
 * ```
 *
 */
public class VirtualMfaDevice internal constructor(
    override val javaResource: com.pulumi.aws.iam.VirtualMfaDevice,
) : KotlinCustomResource(javaResource, VirtualMfaDeviceMapper) {
    /**
     * The Amazon Resource Name (ARN) specifying the virtual mfa device.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The base32 seed defined as specified in [RFC3548](https://tools.ietf.org/html/rfc3548.txt). The `base_32_string_seed` is base64-encoded.
     */
    public val base32StringSeed: Output<String>
        get() = javaResource.base32StringSeed().applyValue({ args0 -> args0 })

    /**
     * The date and time when the virtual MFA device was enabled.
     */
    public val enableDate: Output<String>
        get() = javaResource.enableDate().applyValue({ args0 -> args0 })

    /**
     * The path for the virtual MFA device.
     */
    public val path: Output<String>?
        get() = javaResource.path().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A QR code PNG image that encodes `otpauth://totp/$virtualMFADeviceName@$AccountName?secret=$Base32String` where `$virtualMFADeviceName` is one of the create call arguments. AccountName is the user name if set (otherwise, the account ID), and Base32String is the seed in base32 format.
     */
    public val qrCodePng: Output<String>
        get() = javaResource.qrCodePng().applyValue({ args0 -> args0 })

    /**
     * Map of resource tags for the virtual mfa device. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The associated IAM User name if the virtual MFA device is enabled.
     */
    public val userName: Output<String>
        get() = javaResource.userName().applyValue({ args0 -> args0 })

    /**
     * The name of the virtual MFA device. Use with path to uniquely identify a virtual MFA device.
     */
    public val virtualMfaDeviceName: Output<String>
        get() = javaResource.virtualMfaDeviceName().applyValue({ args0 -> args0 })
}

public object VirtualMfaDeviceMapper : ResourceMapper<VirtualMfaDevice> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iam.VirtualMfaDevice::class == javaResource::class

    override fun map(javaResource: Resource): VirtualMfaDevice = VirtualMfaDevice(
        javaResource as
            com.pulumi.aws.iam.VirtualMfaDevice,
    )
}

/**
 * @see [VirtualMfaDevice].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualMfaDevice].
 */
public suspend fun virtualMfaDevice(
    name: String,
    block: suspend VirtualMfaDeviceResourceBuilder.() -> Unit,
): VirtualMfaDevice {
    val builder = VirtualMfaDeviceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualMfaDevice].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualMfaDevice(name: String): VirtualMfaDevice {
    val builder = VirtualMfaDeviceResourceBuilder()
    builder.name(name)
    return builder.build()
}
