@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.inputs

import com.pulumi.aws.iam.inputs.GetGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getGroup.
 * @property groupName Friendly IAM group name to match.
 */
public data class GetGroupPlainArgs(
    public val groupName: String,
) : ConvertibleToJava<com.pulumi.aws.iam.inputs.GetGroupPlainArgs> {
    override fun toJava(): com.pulumi.aws.iam.inputs.GetGroupPlainArgs =
        com.pulumi.aws.iam.inputs.GetGroupPlainArgs.builder()
            .groupName(groupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGroupPlainArgs].
 */
@PulumiTagMarker
public class GetGroupPlainArgsBuilder internal constructor() {
    private var groupName: String? = null

    /**
     * @param value Friendly IAM group name to match.
     */
    @JvmName("yphclnnlcwomtjum")
    public suspend fun groupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.groupName = mapped
    }

    internal fun build(): GetGroupPlainArgs = GetGroupPlainArgs(
        groupName = groupName ?: throw PulumiNullFieldException("groupName"),
    )
}
