@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.inputs

import com.pulumi.aws.iam.inputs.GetInstanceProfilePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstanceProfile.
 * @property name Friendly IAM instance profile name to match.
 */
public data class GetInstanceProfilePlainArgs(
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.iam.inputs.GetInstanceProfilePlainArgs> {
    override fun toJava(): com.pulumi.aws.iam.inputs.GetInstanceProfilePlainArgs =
        com.pulumi.aws.iam.inputs.GetInstanceProfilePlainArgs.builder()
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstanceProfilePlainArgs].
 */
@PulumiTagMarker
public class GetInstanceProfilePlainArgsBuilder internal constructor() {
    private var name: String? = null

    /**
     * @param value Friendly IAM instance profile name to match.
     */
    @JvmName("bhjmcpdvjoyneqaj")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetInstanceProfilePlainArgs = GetInstanceProfilePlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
