@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.inputs

import com.pulumi.aws.iam.inputs.GetInstanceProfilesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstanceProfiles.
 * @property roleName IAM role name.
 */
public data class GetInstanceProfilesPlainArgs(
    public val roleName: String,
) : ConvertibleToJava<com.pulumi.aws.iam.inputs.GetInstanceProfilesPlainArgs> {
    override fun toJava(): com.pulumi.aws.iam.inputs.GetInstanceProfilesPlainArgs =
        com.pulumi.aws.iam.inputs.GetInstanceProfilesPlainArgs.builder()
            .roleName(roleName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstanceProfilesPlainArgs].
 */
@PulumiTagMarker
public class GetInstanceProfilesPlainArgsBuilder internal constructor() {
    private var roleName: String? = null

    /**
     * @param value IAM role name.
     */
    @JvmName("xfmuooopodkgenjq")
    public suspend fun roleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.roleName = mapped
    }

    internal fun build(): GetInstanceProfilesPlainArgs = GetInstanceProfilesPlainArgs(
        roleName = roleName ?: throw PulumiNullFieldException("roleName"),
    )
}
