@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.inputs

import com.pulumi.aws.iam.inputs.GetPolicyDocumentStatement.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property actions List of actions that this statement either allows or denies. For example, `["ec2:RunInstances", "s3:*"]`.
 * @property conditions Configuration block for a condition. Detailed below.
 * @property effect Whether this statement allows or denies the given actions. Valid values are `Allow` and `Deny`. Defaults to `Allow`.
 * @property notActions List of actions that this statement does *not* apply to. Use to apply a policy statement to all actions *except* those listed.
 * @property notPrincipals Like `principals` except these are principals that the statement does *not* apply to.
 * @property notResources List of resource ARNs that this statement does *not* apply to. Use to apply a policy statement to all resources *except* those listed. Conflicts with `resources`.
 * @property principals Configuration block for principals. Detailed below.
 * @property resources List of resource ARNs that this statement applies to. This is required by AWS if used for an IAM policy. Conflicts with `not_resources`.
 * @property sid Sid (statement ID) is an identifier for a policy statement.
 */
public data class GetPolicyDocumentStatement(
    public val actions: List<String>? = null,
    public val conditions: List<GetPolicyDocumentStatementCondition>? = null,
    public val effect: String? = null,
    public val notActions: List<String>? = null,
    public val notPrincipals: List<GetPolicyDocumentStatementNotPrincipal>? = null,
    public val notResources: List<String>? = null,
    public val principals: List<GetPolicyDocumentStatementPrincipal>? = null,
    public val resources: List<String>? = null,
    public val sid: String? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.inputs.GetPolicyDocumentStatement> {
    override fun toJava(): com.pulumi.aws.iam.inputs.GetPolicyDocumentStatement =
        com.pulumi.aws.iam.inputs.GetPolicyDocumentStatement.builder()
            .actions(actions?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .conditions(
                conditions?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .effect(effect?.let({ args0 -> args0 }))
            .notActions(notActions?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .notPrincipals(
                notPrincipals?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .notResources(notResources?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .principals(
                principals?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resources(resources?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .sid(sid?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPolicyDocumentStatement].
 */
@PulumiTagMarker
public class GetPolicyDocumentStatementBuilder internal constructor() {
    private var actions: List<String>? = null

    private var conditions: List<GetPolicyDocumentStatementCondition>? = null

    private var effect: String? = null

    private var notActions: List<String>? = null

    private var notPrincipals: List<GetPolicyDocumentStatementNotPrincipal>? = null

    private var notResources: List<String>? = null

    private var principals: List<GetPolicyDocumentStatementPrincipal>? = null

    private var resources: List<String>? = null

    private var sid: String? = null

    /**
     * @param value List of actions that this statement either allows or denies. For example, `["ec2:RunInstances", "s3:*"]`.
     */
    @JvmName("oyjrqjrdtxqparrn")
    public suspend fun actions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.actions = mapped
    }

    /**
     * @param values List of actions that this statement either allows or denies. For example, `["ec2:RunInstances", "s3:*"]`.
     */
    @JvmName("mexdmvmxriukmtfk")
    public suspend fun actions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.actions = mapped
    }

    /**
     * @param value Configuration block for a condition. Detailed below.
     */
    @JvmName("ocwcieuboxqmhgln")
    public suspend fun conditions(`value`: List<GetPolicyDocumentStatementCondition>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.conditions = mapped
    }

    /**
     * @param argument Configuration block for a condition. Detailed below.
     */
    @JvmName("rhghwhdqxvnjobbb")
    public suspend
    fun conditions(argument: List<suspend GetPolicyDocumentStatementConditionBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetPolicyDocumentStatementConditionBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.conditions = mapped
    }

    /**
     * @param argument Configuration block for a condition. Detailed below.
     */
    @JvmName("oublvixmchtidwne")
    public suspend fun conditions(
        vararg
        argument: suspend GetPolicyDocumentStatementConditionBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GetPolicyDocumentStatementConditionBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.conditions = mapped
    }

    /**
     * @param argument Configuration block for a condition. Detailed below.
     */
    @JvmName("sedghblbsgbjcqhx")
    public suspend
    fun conditions(argument: suspend GetPolicyDocumentStatementConditionBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetPolicyDocumentStatementConditionBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.conditions = mapped
    }

    /**
     * @param values Configuration block for a condition. Detailed below.
     */
    @JvmName("jfosiujmjctvavvs")
    public suspend fun conditions(vararg values: GetPolicyDocumentStatementCondition) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.conditions = mapped
    }

    /**
     * @param value Whether this statement allows or denies the given actions. Valid values are `Allow` and `Deny`. Defaults to `Allow`.
     */
    @JvmName("bausbokbewroqert")
    public suspend fun effect(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.effect = mapped
    }

    /**
     * @param value List of actions that this statement does *not* apply to. Use to apply a policy statement to all actions *except* those listed.
     */
    @JvmName("evndemvfrbmigyth")
    public suspend fun notActions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.notActions = mapped
    }

    /**
     * @param values List of actions that this statement does *not* apply to. Use to apply a policy statement to all actions *except* those listed.
     */
    @JvmName("feljtoknqtiqcesy")
    public suspend fun notActions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.notActions = mapped
    }

    /**
     * @param value Like `principals` except these are principals that the statement does *not* apply to.
     */
    @JvmName("rumhwomuxbyfcnfa")
    public suspend fun notPrincipals(`value`: List<GetPolicyDocumentStatementNotPrincipal>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.notPrincipals = mapped
    }

    /**
     * @param argument Like `principals` except these are principals that the statement does *not* apply to.
     */
    @JvmName("mgmtfowbamdtklyd")
    public suspend
    fun notPrincipals(argument: List<suspend GetPolicyDocumentStatementNotPrincipalBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetPolicyDocumentStatementNotPrincipalBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.notPrincipals = mapped
    }

    /**
     * @param argument Like `principals` except these are principals that the statement does *not* apply to.
     */
    @JvmName("ywerdmsoqrojojdq")
    public suspend fun notPrincipals(
        vararg
        argument: suspend GetPolicyDocumentStatementNotPrincipalBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GetPolicyDocumentStatementNotPrincipalBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.notPrincipals = mapped
    }

    /**
     * @param argument Like `principals` except these are principals that the statement does *not* apply to.
     */
    @JvmName("mrpekbtxxxgbqfih")
    public suspend
    fun notPrincipals(argument: suspend GetPolicyDocumentStatementNotPrincipalBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetPolicyDocumentStatementNotPrincipalBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.notPrincipals = mapped
    }

    /**
     * @param values Like `principals` except these are principals that the statement does *not* apply to.
     */
    @JvmName("kentwyucnfwgpnfo")
    public suspend fun notPrincipals(vararg values: GetPolicyDocumentStatementNotPrincipal) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.notPrincipals = mapped
    }

    /**
     * @param value List of resource ARNs that this statement does *not* apply to. Use to apply a policy statement to all resources *except* those listed. Conflicts with `resources`.
     */
    @JvmName("tttgnjfwrowsmsmu")
    public suspend fun notResources(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.notResources = mapped
    }

    /**
     * @param values List of resource ARNs that this statement does *not* apply to. Use to apply a policy statement to all resources *except* those listed. Conflicts with `resources`.
     */
    @JvmName("tlirupjljytuiqni")
    public suspend fun notResources(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.notResources = mapped
    }

    /**
     * @param value Configuration block for principals. Detailed below.
     */
    @JvmName("iyllfjwxeoppbqay")
    public suspend fun principals(`value`: List<GetPolicyDocumentStatementPrincipal>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.principals = mapped
    }

    /**
     * @param argument Configuration block for principals. Detailed below.
     */
    @JvmName("gjqqhbxewnbqirdk")
    public suspend
    fun principals(argument: List<suspend GetPolicyDocumentStatementPrincipalBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetPolicyDocumentStatementPrincipalBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.principals = mapped
    }

    /**
     * @param argument Configuration block for principals. Detailed below.
     */
    @JvmName("mpdgcilqdqoseugn")
    public suspend fun principals(
        vararg
        argument: suspend GetPolicyDocumentStatementPrincipalBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GetPolicyDocumentStatementPrincipalBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.principals = mapped
    }

    /**
     * @param argument Configuration block for principals. Detailed below.
     */
    @JvmName("vcrxkjgtlsowxipa")
    public suspend
    fun principals(argument: suspend GetPolicyDocumentStatementPrincipalBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetPolicyDocumentStatementPrincipalBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.principals = mapped
    }

    /**
     * @param values Configuration block for principals. Detailed below.
     */
    @JvmName("gmskbnxlpgtitded")
    public suspend fun principals(vararg values: GetPolicyDocumentStatementPrincipal) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.principals = mapped
    }

    /**
     * @param value List of resource ARNs that this statement applies to. This is required by AWS if used for an IAM policy. Conflicts with `not_resources`.
     */
    @JvmName("dadjklihtspjrwbi")
    public suspend fun resources(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resources = mapped
    }

    /**
     * @param values List of resource ARNs that this statement applies to. This is required by AWS if used for an IAM policy. Conflicts with `not_resources`.
     */
    @JvmName("ghfwlnaikmcvqyvu")
    public suspend fun resources(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resources = mapped
    }

    /**
     * @param value Sid (statement ID) is an identifier for a policy statement.
     */
    @JvmName("svcuabsxxgkjyxwg")
    public suspend fun sid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sid = mapped
    }

    internal fun build(): GetPolicyDocumentStatement = GetPolicyDocumentStatement(
        actions = actions,
        conditions = conditions,
        effect = effect,
        notActions = notActions,
        notPrincipals = notPrincipals,
        notResources = notResources,
        principals = principals,
        resources = resources,
        sid = sid,
    )
}
