@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.inputs

import com.pulumi.aws.iam.inputs.GetPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPolicy.
 * @property arn ARN of the IAM policy.
 * Conflicts with `name` and `path_prefix`.
 * @property name Name of the IAM policy.
 * Conflicts with `arn`.
 * @property pathPrefix Prefix of the path to the IAM policy.
 * Defaults to a slash (`/`).
 * Conflicts with `arn`.
 * @property tags Key-value mapping of tags for the IAM Policy.
 */
public data class GetPolicyPlainArgs(
    public val arn: String? = null,
    public val name: String? = null,
    public val pathPrefix: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.inputs.GetPolicyPlainArgs> {
    override fun toJava(): com.pulumi.aws.iam.inputs.GetPolicyPlainArgs =
        com.pulumi.aws.iam.inputs.GetPolicyPlainArgs.builder()
            .arn(arn?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 }))
            .pathPrefix(pathPrefix?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetPolicyPlainArgsBuilder internal constructor() {
    private var arn: String? = null

    private var name: String? = null

    private var pathPrefix: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value ARN of the IAM policy.
     * Conflicts with `name` and `path_prefix`.
     */
    @JvmName("xsprqgsscdkhoqbc")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.arn = mapped
    }

    /**
     * @param value Name of the IAM policy.
     * Conflicts with `arn`.
     */
    @JvmName("catyelkxoyhwsvab")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Prefix of the path to the IAM policy.
     * Defaults to a slash (`/`).
     * Conflicts with `arn`.
     */
    @JvmName("fyuiqtlwejwgqmvu")
    public suspend fun pathPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pathPrefix = mapped
    }

    /**
     * @param value Key-value mapping of tags for the IAM Policy.
     */
    @JvmName("wfucatdttbjlxgld")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of tags for the IAM Policy.
     */
    @JvmName("lctatbqrcvrtbwla")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetPolicyPlainArgs = GetPolicyPlainArgs(
        arn = arn,
        name = name,
        pathPrefix = pathPrefix,
        tags = tags,
    )
}
