@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.inputs

import com.pulumi.aws.iam.inputs.GetRolesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRoles.
 * @property nameRegex Regex string to apply to the IAM roles list returned by AWS. This allows more advanced filtering not supported from the AWS API. This filtering is done locally on what AWS returns, and could have a performance impact if the result is large. Combine this with other options to narrow down the list AWS returns.
 * @property pathPrefix Path prefix for filtering the results. For example, the prefix `/application_abc/component_xyz/` gets all roles whose path starts with `/application_abc/component_xyz/`. If it is not included, it defaults to a slash (`/`), listing all roles. For more details, check out [list-roles in the AWS CLI reference][1].
 */
public data class GetRolesPlainArgs(
    public val nameRegex: String? = null,
    public val pathPrefix: String? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.inputs.GetRolesPlainArgs> {
    override fun toJava(): com.pulumi.aws.iam.inputs.GetRolesPlainArgs =
        com.pulumi.aws.iam.inputs.GetRolesPlainArgs.builder()
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .pathPrefix(pathPrefix?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRolesPlainArgs].
 */
@PulumiTagMarker
public class GetRolesPlainArgsBuilder internal constructor() {
    private var nameRegex: String? = null

    private var pathPrefix: String? = null

    /**
     * @param value Regex string to apply to the IAM roles list returned by AWS. This allows more advanced filtering not supported from the AWS API. This filtering is done locally on what AWS returns, and could have a performance impact if the result is large. Combine this with other options to narrow down the list AWS returns.
     */
    @JvmName("sdfqkaewuyvnkpxt")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value Path prefix for filtering the results. For example, the prefix `/application_abc/component_xyz/` gets all roles whose path starts with `/application_abc/component_xyz/`. If it is not included, it defaults to a slash (`/`), listing all roles. For more details, check out [list-roles in the AWS CLI reference][1].
     */
    @JvmName("pnwamfuamakrobxl")
    public suspend fun pathPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pathPrefix = mapped
    }

    internal fun build(): GetRolesPlainArgs = GetRolesPlainArgs(
        nameRegex = nameRegex,
        pathPrefix = pathPrefix,
    )
}
