@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.inputs

import com.pulumi.aws.iam.inputs.GetServerCertificatePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getServerCertificate.
 * @property latest sort results by expiration date. returns the certificate with expiration date in furthest in the future.
 * @property name exact name of the cert to lookup
 * @property namePrefix prefix of cert to filter by
 * @property pathPrefix prefix of path to filter by
 */
public data class GetServerCertificatePlainArgs(
    public val latest: Boolean? = null,
    public val name: String? = null,
    public val namePrefix: String? = null,
    public val pathPrefix: String? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.inputs.GetServerCertificatePlainArgs> {
    override fun toJava(): com.pulumi.aws.iam.inputs.GetServerCertificatePlainArgs =
        com.pulumi.aws.iam.inputs.GetServerCertificatePlainArgs.builder()
            .latest(latest?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 }))
            .namePrefix(namePrefix?.let({ args0 -> args0 }))
            .pathPrefix(pathPrefix?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServerCertificatePlainArgs].
 */
@PulumiTagMarker
public class GetServerCertificatePlainArgsBuilder internal constructor() {
    private var latest: Boolean? = null

    private var name: String? = null

    private var namePrefix: String? = null

    private var pathPrefix: String? = null

    /**
     * @param value sort results by expiration date. returns the certificate with expiration date in furthest in the future.
     */
    @JvmName("qpxwwsbadpfcfhqn")
    public suspend fun latest(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.latest = mapped
    }

    /**
     * @param value exact name of the cert to lookup
     */
    @JvmName("bocneolvsrtrmhpf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value prefix of cert to filter by
     */
    @JvmName("lmseuraowucddjpc")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.namePrefix = mapped
    }

    /**
     * @param value prefix of path to filter by
     */
    @JvmName("minjxekknqpctvtu")
    public suspend fun pathPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pathPrefix = mapped
    }

    internal fun build(): GetServerCertificatePlainArgs = GetServerCertificatePlainArgs(
        latest = latest,
        name = name,
        namePrefix = namePrefix,
        pathPrefix = pathPrefix,
    )
}
